/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonProperty;

public class PermissionJsonBean
extends com.atlassian.jira.issue.fields.rest.json.beans.PermissionJsonBean {
    @JsonProperty
    public String name;
    @JsonProperty
    public PermissionType type;
    @JsonProperty
    public String description;

    public PermissionJsonBean() {
    }

    public PermissionJsonBean(String key, String name, PermissionType type, String description) {
        this.key(key);
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public static PermissionJsonBean fromGlobalPermission(GlobalPermissionType globalPermission, JiraAuthenticationContext authenticationContext) {
        PermissionJsonBean bean = new PermissionJsonBean();
        bean.key(globalPermission.getKey());
        bean.name = authenticationContext.getI18nHelper().getText(globalPermission.getNameI18nKey());
        bean.description = authenticationContext.getI18nHelper().getText(globalPermission.getDescriptionI18nKey());
        bean.type = PermissionType.GLOBAL;
        return bean;
    }

    public static PermissionJsonBean fromProjectPermission(ProjectPermission projectPermission, JiraAuthenticationContext authenticationContext) {
        PermissionJsonBean bean = new PermissionJsonBean();
        bean.key(projectPermission.getKey());
        bean.name = authenticationContext.getI18nHelper().getText(projectPermission.getNameI18nKey());
        bean.description = authenticationContext.getI18nHelper().getText(projectPermission.getDescriptionI18nKey());
        bean.type = PermissionType.PROJECT;
        return bean;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.id()).add("key", (Object)this.key()).add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).toString();
    }

    static enum PermissionType {
        GLOBAL,
        PROJECT;

    }
}

