/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.password;

import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.rest.v2.password.PasswordPolicyCreateUserBean;
import com.atlassian.jira.rest.v2.password.PasswordPolicyUpdateUserBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="password")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PasswordResource {
    private final PasswordPolicyManager passwordPolicyManager;
    private final UserManager userManager;

    public PasswordResource(PasswordPolicyManager passwordPolicyManager, UserManager userManager) {
        this.passwordPolicyManager = passwordPolicyManager;
        this.userManager = userManager;
    }

    @GET
    @Path(value="policy")
    @ResponseType(value=List.class, genericTypes={String.class})
    public Response getPasswordPolicy(@QueryParam(value="hasOldPassword") @DefaultValue(value="false") boolean hasOldPassword) {
        return Response.ok((Object)this.passwordPolicyManager.getPolicyDescription(hasOldPassword)).build();
    }

    @POST
    @Path(value="policy/createUser")
    @RequestType(value=PasswordPolicyCreateUserBean.class)
    @ResponseType(value=List.class, genericTypes={String.class})
    public Response policyCheckCreateUser(PasswordPolicyCreateUserBean bean) {
        if (bean == null || StringUtils.isEmpty((CharSequence)bean.getUsername()) || StringUtils.isEmpty((CharSequence)bean.getPassword())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok(PasswordResource.snippets(this.passwordPolicyManager.checkPolicy(bean.getUsername(), bean.getDisplayName(), bean.getEmailAddress(), bean.getPassword()))).build();
    }

    @POST
    @Path(value="policy/updateUser")
    @RequestType(value=PasswordPolicyUpdateUserBean.class)
    @ResponseType(value=List.class, genericTypes={String.class})
    public Response policyCheckUpdateUser(PasswordPolicyUpdateUserBean bean) {
        if (bean == null || StringUtils.isEmpty((CharSequence)bean.getUsername()) || StringUtils.isEmpty((CharSequence)bean.getNewPassword())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ApplicationUser existing = this.userManager.getUserByName(bean.getUsername());
        if (existing == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(PasswordResource.snippets(this.passwordPolicyManager.checkPolicy(existing, bean.getOldPassword(), bean.getNewPassword()))).build();
    }

    private static List<String> snippets(Collection<WebErrorMessage> messages) {
        ImmutableList.Builder snippets = ImmutableList.builder();
        for (WebErrorMessage message : messages) {
            snippets.add((Object)message.getSnippet());
        }
        return snippets.build();
    }
}

