/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.notification;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationSchemeService;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBeanFactory;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rest.annotation.ResponseType;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/notificationscheme")
@Produces(value={"application/json"})
public class ProjectNotificationSchemeResource {
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final NotificationSchemeService notificationSchemeService;
    private final NotificationSchemeBeanFactory notificationSchemeBeanFactory;

    public ProjectNotificationSchemeResource(ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, NotificationSchemeService notificationSchemeService, NotificationSchemeBeanFactory notificationSchemeBeanFactory) {
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.notificationSchemeService = notificationSchemeService;
        this.notificationSchemeBeanFactory = notificationSchemeBeanFactory;
    }

    @GET
    @ResponseType(value=NotificationSchemeBean.class)
    public Response getNotificationScheme(final @PathParam(value="projectKeyOrId") String projectKeyOrId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on((Function)new Function<List<NotificationSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<NotificationSchemeExpandParam> expands) {
                ApplicationUser user = ProjectNotificationSchemeResource.this.jiraAuthenticationContext.getUser();
                ServiceOutcome schemeForProject = ProjectNotificationSchemeResource.this.getNotificationSchemeForProject(user, projectKeyOrId);
                return (Response)ProjectNotificationSchemeResource.this.responseFactory.validateOutcome(schemeForProject).left().on((Function)new Function<NotificationScheme, Response>(){

                    @Override
                    public Response apply(NotificationScheme notificationScheme) {
                        return ProjectNotificationSchemeResource.this.responseFactory.okNoCache(ProjectNotificationSchemeResource.this.notificationSchemeBeanFactory.createNotificationSchemeBean(notificationScheme, expands));
                    }
                });
            }
        });
    }

    private ServiceOutcome<NotificationScheme> getNotificationSchemeForProject(ApplicationUser user, String projectKeyOrId) {
        try {
            return this.notificationSchemeService.getNotificationSchemeForProject(user, Long.valueOf(Long.parseLong(projectKeyOrId)));
        }
        catch (NumberFormatException e) {
            return this.notificationSchemeService.getNotificationSchemeForProject(user, projectKeyOrId);
        }
    }
}

