/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.license;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.rest.v2.license.LicenseValidationResults;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="licenseValidator")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LicenceValidator {
    private final I18nHelper i18nHelper;
    private final JiraLicenseService licenseService;

    public LicenceValidator(JiraLicenseService licenseService, I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.licenseService = licenseService;
    }

    @POST
    public LicenseValidationResults validate(String license) {
        JiraLicenseService.ValidationResult validationResults = this.licenseService.validate(this.i18nHelper, license);
        return this.extractValidationDetails(validationResults);
    }

    private LicenseValidationResults extractValidationDetails(JiraLicenseService.ValidationResult validationResults) {
        LicenseValidationResults results = new LicenseValidationResults();
        results.setErrors(validationResults.getErrorCollection().getErrors());
        results.setLicenseString(validationResults.getLicenseString());
        return results;
    }
}

