/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.worklog;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogWithPaginationBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

public class IssueWorklogResource {
    private WorklogService worklogService;
    private UserManager userManager;
    private JiraAuthenticationContext authenticationContext;
    private I18nHelper i18n;
    private TimeTrackingConfiguration timeTrackingConfiguration;
    private JiraBaseUrls jiraBaseUrls;
    private EmailFormatter emailFormatter;

    public IssueWorklogResource(WorklogService worklogService, JiraAuthenticationContext authenticationContext, UserManager userManager, I18nHelper i18n, TimeTrackingConfiguration timeTrackingConfiguration, JiraBaseUrls jiraBaseUrls, EmailFormatter emailFormatter) {
        this.worklogService = worklogService;
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.i18n = i18n;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.jiraBaseUrls = jiraBaseUrls;
        this.emailFormatter = emailFormatter;
    }

    public Response getIssueWorklogs(Issue issue) {
        return Response.ok((Object)this.convertToBean(this.getIssueWorklogsObjects(issue))).cacheControl(CacheControl.never()).build();
    }

    public List<Worklog> getIssueWorklogsObjects(Issue issue) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authenticationContext.getUser());
        return this.worklogService.getByIssueVisibleToUser((JiraServiceContext)serviceContext, issue);
    }

    public Response getWorklogForIssue(String worklogId, Issue issue) {
        try {
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authenticationContext.getUser());
            Worklog worklog = this.worklogService.getById((JiraServiceContext)serviceContext, Long.valueOf(Long.parseLong(worklogId)));
            if (worklog != null) {
                if (issue.getId().equals(worklog.getIssue().getId())) {
                    return Response.ok((Object)WorklogJsonBean.getWorklog((Worklog)worklog, (JiraBaseUrls)this.jiraBaseUrls, (UserManager)this.userManager, (TimeTrackingConfiguration)this.timeTrackingConfiguration, (ApplicationUser)this.authenticationContext.getUser(), (EmailFormatter)this.emailFormatter)).cacheControl(CacheControl.never()).build();
                }
                ErrorCollection errors = ErrorCollection.of(serviceContext.getErrorCollection());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
            }
            ErrorCollection errors = ErrorCollection.of(serviceContext.getErrorCollection());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("worklog.service.error.no.worklog.for.id", worklogId)));
        }
    }

    public Response addWorklog(Issue issue, WorklogJsonBean request, WorklogAdjustmentRequest adjustEstimateDetails, UriInfo uriInfo) {
        return this.doOperation(issue, request, adjustEstimateDetails, WorklogOperation.ADD, uriInfo);
    }

    public Response updateWorklog(Issue issue, WorklogJsonBean request, WorklogAdjustmentRequest adjustEstimateDetails, UriInfo uriInfo) {
        return this.doOperation(issue, request, adjustEstimateDetails, WorklogOperation.EDIT, uriInfo);
    }

    public Response deleteWorklog(Issue issue, WorklogJsonBean request, WorklogAdjustmentRequest adjustEstimateDetails, UriInfo uriInfo) {
        return this.doOperation(issue, request, adjustEstimateDetails, WorklogOperation.DELETE, uriInfo);
    }

    private Response doOperation(Issue issue, WorklogJsonBean request, WorklogAdjustmentRequest adjustEstimateDetails, WorklogOperation operation, UriInfo uriInfo) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getUser());
        if (request == null) {
            return Response.serverError().build();
        }
        WorklogInputParameters worklogInputParameters = operation.prepareData(jiraServiceContext, issue, request, adjustEstimateDetails);
        if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            WorklogSystemField.WorklogValue.AdjustEstimate mode = adjustEstimateDetails.getMode() != null ? adjustEstimateDetails.getMode() : WorklogSystemField.WorklogValue.AdjustEstimate.AUTO;
            Worklog worklog = null;
            switch (mode) {
                case NEW: {
                    worklog = operation.validateAndPerformAndSetNewEstimate((JiraServiceContext)jiraServiceContext, issue, worklogInputParameters);
                    break;
                }
                case MANUAL: {
                    worklog = operation.validateAndPerformAndManualAdjustEstimate((JiraServiceContext)jiraServiceContext, issue, worklogInputParameters);
                    break;
                }
                case LEAVE: {
                    worklog = operation.validateAndPerformAndLeaveEstimate((JiraServiceContext)jiraServiceContext, issue, worklogInputParameters);
                    break;
                }
                case AUTO: {
                    worklog = operation.validateAndPerformAndAutoAdjustEstimate((JiraServiceContext)jiraServiceContext, issue, worklogInputParameters);
                }
            }
            if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) {
                if (worklog == null) {
                    jiraServiceContext.getErrorCollection().addErrorMessage(this.i18n.getText("rest.worklog.error.unknown"));
                } else {
                    return operation.prepareSuccessfulResponse(this.convertToBean(worklog));
                }
            }
        }
        throw new RESTException(ErrorCollection.of(jiraServiceContext.getErrorCollection()));
    }

    private WorklogJsonBean convertToBean(Worklog worklog) {
        return WorklogJsonBean.getWorklog((Worklog)worklog, (JiraBaseUrls)this.jiraBaseUrls, (UserManager)this.userManager, (TimeTrackingConfiguration)this.timeTrackingConfiguration, (ApplicationUser)this.authenticationContext.getUser(), (EmailFormatter)this.emailFormatter);
    }

    private WorklogWithPaginationBean convertToBean(List<Worklog> worklogs) {
        WorklogWithPaginationBean worklogWithPaginationBean = new WorklogWithPaginationBean();
        worklogWithPaginationBean.setMaxResults(Integer.valueOf(worklogs.size()));
        worklogWithPaginationBean.setTotal(Integer.valueOf(worklogs.size()));
        worklogWithPaginationBean.setStartAt(Integer.valueOf(0));
        ArrayList<WorklogJsonBean> beans = new ArrayList<WorklogJsonBean>(worklogs.size());
        for (Worklog worklog : worklogs) {
            beans.add(this.convertToBean(worklog));
        }
        worklogWithPaginationBean.setWorklogs(beans);
        return worklogWithPaginationBean;
    }

    public static class WorklogAdjustmentRequest {
        private final String mode;
        private final String newEstimate;
        private final String reduceBy;
        private final String increaseBy;

        public WorklogAdjustmentRequest(String mode, String newEstimate, String reduceBy, String increaseBy) {
            this.mode = mode;
            this.newEstimate = newEstimate;
            this.reduceBy = reduceBy;
            this.increaseBy = increaseBy;
        }

        public WorklogSystemField.WorklogValue.AdjustEstimate getMode() {
            if (StringUtils.isNotBlank((CharSequence)this.mode)) {
                return WorklogSystemField.WorklogValue.AdjustEstimate.valueOf((String)this.mode.toUpperCase());
            }
            return null;
        }

        public String getModeString() {
            return this.mode;
        }

        public String getNewEstimate() {
            return this.newEstimate;
        }

        public String getReduceBy() {
            return this.reduceBy;
        }

        public String getIncreaseBy() {
            return this.increaseBy;
        }
    }
}

