/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.rest.v2.issue.users.IssueInvolvementBean;
import com.atlassian.jira.rest.v2.issue.users.UserIssueRelevanceBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueRelevance;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;

public class UserIssueRelevanceBeanBuilder {
    private final EmailFormatter emailFormatter;
    private final I18nHelper i18n;
    private final JiraBaseUrls jiraBaseUrls;
    private final ApplicationUser loggedInUser;
    private final TimeZone timeZone;
    private final AvatarService avatarService;

    public UserIssueRelevanceBeanBuilder(EmailFormatter emailFormatter, I18nHelper i18n, JiraBaseUrls jiraBaseUrls, ApplicationUser loggedInUser, TimeZone timeZone, AvatarService avatarService) {
        this.emailFormatter = emailFormatter;
        this.i18n = i18n;
        this.jiraBaseUrls = jiraBaseUrls;
        this.loggedInUser = loggedInUser;
        this.timeZone = timeZone;
        this.avatarService = avatarService;
    }

    public UserIssueRelevanceBean build(UserIssueRelevance userIssueRelevance) {
        ApplicationUser user = userIssueRelevance.getUser();
        List<IssueInvolvementBean> issueInvolvements = userIssueRelevance.getIssueInvolvements().stream().map(issueInvolvement -> new IssueInvolvementBean(issueInvolvement.getId(), this.i18n.getText(issueInvolvement.getI18nKey()))).collect(Collectors.toList());
        return new UserIssueRelevanceBean(this.createSelfLink(user), user.getKey(), user.getName(), user.getDisplayName(), user.isActive(), this.emailFormatter.formatEmail(user.getEmailAddress(), this.loggedInUser), this.getAvatarURLs(user), this.timeZone, this.i18n.getLocale(), issueInvolvements, userIssueRelevance.getHighestIssueInvolvementRank(), userIssueRelevance.getLatestCommentCreationTime());
    }

    private URI createSelfLink(ApplicationUser user) {
        return UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(UserResource.class).queryParam("username", new Object[]{"{0}"}).build(new Object[]{user.getUsername()});
    }

    private Map<String, URI> getAvatarURLs(ApplicationUser forUser) {
        Avatar avatar = this.avatarService.getAvatar(forUser, forUser);
        return avatar != null ? AvatarUrls.getAvatarURLs((ApplicationUser)forUser, (Avatar)avatar) : Collections.emptyMap();
    }
}

