/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.customfield.DefaultCustomFieldService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.rest.annotation.ResponseType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="customFields")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomFieldBeanFactory customFieldBeanFactory;
    private final DefaultCustomFieldService customFieldService;

    public CustomFieldResource(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldBeanFactory customFieldBeanFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldBeanFactory = customFieldBeanFactory;
        this.customFieldService = (DefaultCustomFieldService)ComponentAccessor.getComponent(DefaultCustomFieldService.class);
    }

    @GET
    @ResponseType(value=PageBean.class, genericTypes={CustomFieldBean.class})
    public Response getCustomFields(@DefaultValue(value="1") @QueryParam(value="startAt") long startAt, @DefaultValue(value="50") @QueryParam(value="maxResults") int maxResults, @QueryParam(value="search") String searchString, @QueryParam(value="projectIds") List<String> projectIds, @QueryParam(value="screenIds") List<String> screenIds, @QueryParam(value="types") List<String> types) {
        long pageStart = (startAt - 1L) * (long)maxResults;
        ServiceOutcomeImpl customfields = this.customFieldService.findCustomFields(this.jiraAuthenticationContext.getLoggedInUser(), searchString, types, projectIds, screenIds);
        if (!customfields.isValid()) {
            return CustomFieldResource.createErrorResponse((ServiceResult)customfields);
        }
        PageRequest pageRequest = PageRequests.request((Long)pageStart, (Integer)maxResults);
        Page customFieldPage = Pages.toPage((Iterable)((Iterable)customfields.getReturnedValue()), (PageRequest)pageRequest);
        PageBean<CustomFieldBean> bean = PageBean.from(pageRequest, customFieldPage).build(this.customFieldBeanFactory::from);
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    public static Response createErrorResponse(ServiceResult result) {
        Set reasons = result.getErrorCollection().getReasons();
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)reasons);
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.NOT_FOUND;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of(result.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }
}

