/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.VelocityRequestContextFactories;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBeanBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="customFieldOption")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldOptionResource {
    private JiraAuthenticationContext authContext;
    private OptionsManager optionsManager;
    private VelocityRequestContextFactory velocityRequestContextFactory;
    private I18nHelper i18n;
    private ContextUriInfo contextUriInfo;

    private CustomFieldOptionResource() {
    }

    public CustomFieldOptionResource(JiraAuthenticationContext authContext, OptionsManager optionsManager, VelocityRequestContextFactory velocityRequestContextFactory, I18nHelper i18n, ContextUriInfo contextUriInfo) {
        this.authContext = authContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.i18n = i18n;
        this.contextUriInfo = contextUriInfo;
        this.optionsManager = optionsManager;
    }

    @GET
    @Path(value="{id}")
    @ResponseType(value=CustomFieldOptionBean.class)
    public Response getCustomFieldOption(@PathParam(value="id") String id) {
        Option option = null;
        try {
            option = this.optionsManager.findByOptionId(Long.valueOf(id));
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.custom.field.option.not.found", id)));
        }
        if (option == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.custom.field.option.not.found", id)));
        }
        Response.ResponseBuilder rb = Response.ok((Object)new CustomFieldOptionBeanBuilder().baseURI(VelocityRequestContextFactories.getBaseURI(this.velocityRequestContextFactory)).context(this.contextUriInfo).customFieldOption(option).build());
        return rb.cacheControl(CacheControl.never()).build();
    }
}

