/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.inject.Inject;
import javax.ws.rs.core.UriInfo;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldBeanFactory {
    private final UriInfo context;
    private final FieldScreenManager fieldScreenManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public CustomFieldBeanFactory(UriInfo context, FieldScreenManager fieldScreenManager, ManagedConfigurationItemService managedConfigurationItemService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.context = context;
        this.fieldScreenManager = fieldScreenManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public CustomFieldBean from(CustomField cf) {
        return new CustomFieldBean(cf, new ResourceUriBuilder().build(this.context, CustomFieldResource.class, cf.getId()), this.fieldScreenManager.getFieldScreenTabs(cf.getId()).size(), this.isFieldManaged(cf), this.isFieldLocked(cf));
    }

    private boolean isFieldManaged(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        return item.isManaged();
    }

    private boolean isFieldLocked(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        if (!item.isManaged()) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.jiraAuthenticationContext.getLoggedInUser(), item);
    }
}

