/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.rest.api.customfield.CustomFieldDefinitionJsonBean;
import java.net.URI;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlRootElement(name="customField")
public class CustomFieldBean
extends CustomFieldDefinitionJsonBean {
    @JsonProperty
    private Long numericId;
    @JsonProperty
    private boolean isLocked;
    @JsonProperty
    private boolean isManaged;
    @JsonProperty
    private boolean isAllProjects;
    @JsonProperty
    private int projectsCount;
    @JsonProperty
    private int screensCount;

    private CustomFieldBean() {
    }

    public CustomFieldBean(CustomField customField, URI self, int screensCount) {
        this(customField, self, screensCount, false, false);
    }

    public CustomFieldBean(CustomField customField, URI self, int screensCount, boolean isManaged, boolean isLocked) {
        super(customField.getId(), customField.getName(), customField.getDescriptionProperty().getViewHtml(), customField.getCustomFieldType().getName(), Optional.ofNullable(customField.getCustomFieldSearcher()).map(searcher -> searcher.getDescriptor().getKey()).orElse(null), self);
        this.numericId = customField.getIdAsLong();
        this.isAllProjects = customField.isAllProjects();
        this.projectsCount = customField.getAssociatedProjectObjects().size();
        this.screensCount = screensCount;
        this.isManaged = isManaged;
        this.isLocked = isLocked;
    }
}

