/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.format;

import com.atlassian.jira.rest.bind.DateTimeAdapter;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="attachment")
public class AttachmentBean {
    @XmlElement
    private URI self;
    @XmlElement
    private String filename;
    @XmlElement
    private UserBean author;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date created;
    @XmlElement
    private long size;
    @XmlElement
    private String mimeType;
    @XmlElement
    private HashMap<String, Object> properties;
    @XmlElement
    private String content;
    @XmlElement
    private String thumbnail;
    public static final AttachmentBean DOC_EXAMPLE;
    public static final AttachmentBean DOC_EXAMPLE_2;
    public static final List<AttachmentBean> DOC_EXAMPLE_LIST;

    private AttachmentBean() {
    }

    public AttachmentBean(URI self, String filename, UserBean author, Date created, long filesize, String mimeType, HashMap<String, Object> properties, String content, String thumbnail) {
        this.self = self;
        this.filename = filename;
        this.author = author;
        this.created = created;
        this.size = filesize;
        this.mimeType = mimeType;
        this.properties = properties;
        this.content = content;
        this.thumbnail = thumbnail;
    }

    static {
        try {
            DOC_EXAMPLE = new AttachmentBean();
            AttachmentBean.DOC_EXAMPLE.self = new URI("http://www.example.com/jira/rest/api/2.0/attachments/10000");
            AttachmentBean.DOC_EXAMPLE.filename = "picture.jpg";
            AttachmentBean.DOC_EXAMPLE.author = UserBean.SHORT_DOC_EXAMPLE;
            AttachmentBean.DOC_EXAMPLE.created = new Date();
            AttachmentBean.DOC_EXAMPLE.size = 23123L;
            AttachmentBean.DOC_EXAMPLE.mimeType = "image/jpeg";
            AttachmentBean.DOC_EXAMPLE.content = "http://www.example.com/jira/attachments/10000";
            AttachmentBean.DOC_EXAMPLE.thumbnail = "http://www.example.com/jira/secure/thumbnail/10000";
            DOC_EXAMPLE_2 = new AttachmentBean();
            AttachmentBean.DOC_EXAMPLE_2.self = new URI("http://www.example.com/jira/rest/api/2.0/attachments/10001");
            AttachmentBean.DOC_EXAMPLE_2.filename = "dbeuglog.txt";
            AttachmentBean.DOC_EXAMPLE_2.author = UserBean.SHORT_DOC_EXAMPLE;
            AttachmentBean.DOC_EXAMPLE_2.created = new Date();
            AttachmentBean.DOC_EXAMPLE_2.size = 2460L;
            AttachmentBean.DOC_EXAMPLE_2.mimeType = "text/plain";
            AttachmentBean.DOC_EXAMPLE_2.content = "http://www.example.com/jira/attachments/10001";
            AttachmentBean.DOC_EXAMPLE_2.thumbnail = "http://www.example.com/jira/secure/thumbnail/10002";
            DOC_EXAMPLE_LIST = ImmutableList.of((Object)DOC_EXAMPLE, (Object)DOC_EXAMPLE_2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

