/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.factory.ErrorCollectionFactory;
import com.atlassian.jira.rest.factory.JiraServiceContextFactory;
import com.atlassian.jira.rest.factory.Responder;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttachmentResourceStrategy {
    private static final Logger log = LoggerFactory.getLogger(AttachmentResourceStrategy.class);
    private final AttachmentAuthorizer authorizer;
    private final AttachmentOperation operation;
    private final Responder responder;
    private final ErrorCollectionFactory errorCollectionFactory;
    private final AttachmentManager attachmentManager;
    private final AttachmentService attachmentService;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final JiraServiceContextFactory contextFactory;

    AttachmentResourceStrategy(AttachmentAuthorizer authorization, AttachmentOperation operation, Responder responder, ErrorCollectionFactory errorCollectionFactory, AttachmentManager attachmentManager, AttachmentService attachmentService, JiraAuthenticationContext authContext, I18nHelper i18n, JiraServiceContextFactory contextFactory) {
        this.authorizer = authorization;
        this.operation = operation;
        this.responder = responder;
        this.errorCollectionFactory = errorCollectionFactory;
        this.attachmentManager = attachmentManager;
        this.attachmentService = attachmentService;
        this.authContext = authContext;
        this.i18n = i18n;
        this.contextFactory = contextFactory;
    }

    public Response processAttachment(String id) {
        try {
            return this.tryProcessingAttachment(id);
        }
        catch (AttachmentNotFoundException e) {
            return this.getNotFoundResponse(id);
        }
        catch (NumberFormatException e) {
            return this.getNotFoundResponse(id);
        }
        catch (Exception e) {
            log.error("Failed to process attachment with id=" + id, (Throwable)e);
            return this.responder.exception(e);
        }
    }

    private Response tryProcessingAttachment(String id) {
        if (!this.attachmentManager.attachmentsEnabled()) {
            String message = this.i18n.getText("attachment.service.error.disabled");
            ErrorCollection errors = this.errorCollectionFactory.of(ErrorCollection.Reason.NOT_FOUND, message);
            return this.responder.restfulErrors(errors);
        }
        ApplicationUser user = this.authContext.getUser();
        JiraServiceContext serviceContext = this.contextFactory.createContext(user);
        long attachmentId = Long.parseLong(id);
        Attachment attachment = this.attachmentService.getAttachment(serviceContext, Long.valueOf(attachmentId));
        com.atlassian.jira.util.ErrorCollection serviceErrors = serviceContext.getErrorCollection();
        if (serviceErrors.hasAnyErrors()) {
            ErrorCollection errors = this.errorCollectionFactory.of(serviceErrors);
            errors.reason(ErrorCollection.Reason.NOT_FOUND);
            return this.responder.restfulErrors(errors);
        }
        if (this.authorizer.authorize(attachment, user)) {
            return this.operation.perform(attachment, serviceContext);
        }
        String message = this.authorizer.getNoPermissionMessage(this.i18n, id);
        ErrorCollection errors = this.errorCollectionFactory.of(ErrorCollection.Reason.FORBIDDEN, message);
        return this.responder.restfulErrors(errors);
    }

    private Response getNotFoundResponse(String id) {
        String message = this.i18n.getText("rest.attachment.error.not.found", id);
        ErrorCollection errors = this.errorCollectionFactory.of(ErrorCollection.Reason.NOT_FOUND, message);
        return this.responder.restfulErrors(errors);
    }
}

