/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.v2.issue.Examples;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="watchers")
public class WatchersBean {
    static final WatchersBean DOC_EXAMPLE = new WatchersBean(Examples.restURI("issue/EX-1/watchers").toString(), false, Arrays.asList(UserJsonBean.USER_SHORT_DOC_EXAMPLE), 1);
    @XmlElement
    private String self;
    @XmlElement(name="isWatching")
    private Boolean isWatching;
    @XmlElement(name="watchCount")
    private int watchCount;
    @XmlElement
    private List<UserJsonBean> watchers;

    public WatchersBean(String selfUri, Boolean watching, List<UserJsonBean> userBeans, int count) {
        this.self = selfUri;
        this.isWatching = watching;
        this.watchCount = count;
        this.watchers = userBeans;
    }

    public WatchersBean(String selfUri, Boolean watching, int count) {
        this.self = selfUri;
        this.isWatching = watching;
        this.watchCount = count;
    }

    public static class Builder {
        private String self;
        private Boolean isWatching;
        private Integer watchCount;
        private List<UserJsonBean> watchers;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder self(String self) {
            this.self = self;
            return this;
        }

        public Builder isWatching(boolean isWatching) {
            this.isWatching = isWatching;
            return this;
        }

        public Builder watchCount(int count) {
            this.watchCount = count;
            return this;
        }

        public Builder watchers(List<UserJsonBean> users) {
            this.watchers = users;
            return this;
        }

        public WatchersBean build() {
            if (this.self == null) {
                throw new IllegalArgumentException("self URI must be set");
            }
            if (this.isWatching == null) {
                throw new IllegalArgumentException("isWatching must be set");
            }
            if (this.watchCount == null) {
                throw new IllegalArgumentException("watchCount must be set");
            }
            if (this.watchers != null) {
                return new WatchersBean(this.self, this.isWatching, this.watchers, this.watchCount);
            }
            return new WatchersBean(this.self, this.isWatching, this.watchCount);
        }
    }
}

