/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserWriteBean {
    private static final UserWriteBean DOC_EXAMPLE_CREATE;
    private static final UserWriteBean DOC_EXAMPLE_CREATED;
    private static final UserWriteBean DOC_EXAMPLE;
    private static final UserWriteBean DOC_EXAMPLE_UPDATE;
    private static final UserWriteBean DOC_EXAMPLE_UPDATED;
    private static final UserWriteBean DOC_EXAMPLE_UPDATE_MYSELF;
    private static final UserWriteBean DOC_EXAMPLE_UPDATED_MYSELF;
    @JsonProperty
    private String self;
    @JsonProperty
    private String key;
    @JsonProperty
    private String name;
    @JsonProperty
    private String password;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private String notification;
    @JsonProperty
    private Boolean active;
    @JsonProperty
    private List<String> applicationKeys;

    private UserWriteBean() {
    }

    public UserWriteBean(String self, String key, String name, String password, String emailAddress, String displayName, String notification, Boolean active, List<String> applicationKeys) {
        this.self = self;
        this.key = key;
        this.name = name;
        this.password = password;
        this.emailAddress = emailAddress;
        this.displayName = displayName;
        this.notification = notification;
        this.active = active;
        this.applicationKeys = applicationKeys;
    }

    public String getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNotification() {
        return this.notification;
    }

    public Boolean isActive() {
        return this.active;
    }

    public List<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    static {
        String key = "charlie";
        DOC_EXAMPLE_CREATE = new Builder().name("charlie").password("abracadabra").emailAddress("charlie@atlassian.com").displayName("Charlie of Atlassian").applicationKeys((List<String>)ImmutableList.of((Object)"jira-core")).toUserBean();
        DOC_EXAMPLE_CREATED = new Builder().self("http://www.example.com/jirahttp://www.example.com/jira/rest/api/2/user/charlie").key("charlie").name("charlie").emailAddress("charlie@atlassian.com").displayName("Charlie of Atlassian").toUserBean();
        DOC_EXAMPLE = new Builder().self("http://www.example.com/jirahttp://www.example.com/jira/rest/api/2/user/charlie").key("charlie").name("charlie").emailAddress("charlie@atlassian.com").displayName("Charlie of Atlassian").toUserBean();
        DOC_EXAMPLE_UPDATE = new Builder().name("eddie").emailAddress("eddie@atlassian.com").displayName("Eddie of Atlassian").active(true).toUserBean();
        DOC_EXAMPLE_UPDATED = new Builder().self("http://www.example.com/jirahttp://www.example.com/jira/rest/api/2/user/charlie").key("charlie").name("eddie").emailAddress("eddie@atlassian.com").displayName("Eddie of Atlassian").toUserBean();
        DOC_EXAMPLE_UPDATE_MYSELF = new Builder().password("abracadabra").emailAddress("eddie@atlassian.com").displayName("Eddie of Atlassian").toUserBean();
        DOC_EXAMPLE_UPDATED_MYSELF = new Builder().self("http://www.example.com/jirahttp://www.example.com/jira/rest/api/2/user/charlie").key("charlie").name("eddie").emailAddress("eddie@atlassian.com").displayName("Eddie of Atlassian").toUserBean();
    }

    public static final class Builder {
        private String self;
        private String key;
        private String name;
        private String password;
        private String emailAddress;
        private String displayName;
        private String notification;
        private Boolean active;
        private List<String> applicationKeys;

        public UserWriteBean toUserBean() {
            return new UserWriteBean(this.self, this.key, this.name, this.password, this.emailAddress, this.displayName, this.notification, this.active, this.applicationKeys);
        }

        public Builder self(String self) {
            this.self = self;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder notification(String notification) {
            this.notification = notification;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder applicationKeys(List<String> applicationKeys) {
            this.applicationKeys = applicationKeys;
            return this;
        }
    }
}

