/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.event.user.UserAvatarUpdatedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.UpdateUserApplicationHelper;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBeanConverter;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.PasswordBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UserPickerResultsBean;
import com.atlassian.jira.rest.v2.issue.UserWriteBean;
import com.atlassian.jira.rest.v2.issue.users.UserPickerResourceHelper;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@Path(value="user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserResource {
    public static final int DEFAULT_USERS_RETURNED = 50;
    public static final int MAX_USERS_RETURNED = 1000;
    private static final int MAX_LENGTH = 255;
    private final UserService userService;
    private final UserUtil userUtil;
    private final PasswordPolicyManager passwordPolicyManager;
    private final I18nHelper i18n;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authContext;
    private final TimeZoneManager timeZoneManager;
    private final AvatarService avatarService;
    private final AvatarResourceHelper avatarResourceHelper;
    private final UserPropertyManager userPropertyManager;
    private final PermissionManager permissionManager;
    private final ProjectService projectService;
    private final IssueService issueService;
    private final ProjectManager projectManager;
    private final AvatarManager avatarManager;
    private final EventPublisher eventPublisher;
    private final AssigneeService assigneeService;
    private final IssueManager issueManager;
    private final UserPickerResourceHelper userPickerHelper;
    private final JiraBaseUrls jiraBaseUrls;
    private final ColumnService columnService;
    private final XsrfInvocationChecker xsrfChecker;
    private final I18nHelper.BeanFactory beanFactory;
    private final ApplicationRoleManager applicationRoleManager;
    private final ApplicationRoleBeanConverter applicationRoleBeanConverter;
    private final UpdateUserApplicationHelper updateUserApplicationHelper;
    private final ResponseFactory responseFactory;

    public UserResource(UserService userService, UserUtil userUtil, PasswordPolicyManager passwordPolicyManager, I18nHelper i18n, EmailFormatter emailFormatter, JiraAuthenticationContext authContext, TimeZoneManager timeZoneManager, AvatarPickerHelper avatarPickerHelper, AvatarManager avatarManager, AvatarService avatarService, AttachmentHelper attachmentHelper, UserPropertyManager userPropertyManager, PermissionManager permissionManager, ProjectService projectService, IssueService issueService, ProjectManager projectManager, EventPublisher eventPublisher, AssigneeService assigneeService, IssueManager issueManager, UserPickerResourceHelper userPickerHelper, JiraBaseUrls jiraBaseUrls, ColumnService columnService, XsrfInvocationChecker xsrfChecker, UserManager userManager, I18nHelper.BeanFactory beanFactory, ApplicationRoleManager applicationRoleManager, ApplicationRoleBeanConverter applicationRoleBeanConverter, UpdateUserApplicationHelper updateUserApplicationHelper, ResponseFactory responseFactory) {
        this.userService = userService;
        this.passwordPolicyManager = passwordPolicyManager;
        this.userPropertyManager = userPropertyManager;
        this.permissionManager = permissionManager;
        this.projectService = projectService;
        this.issueService = issueService;
        this.projectManager = projectManager;
        this.avatarManager = avatarManager;
        this.eventPublisher = eventPublisher;
        this.assigneeService = assigneeService;
        this.issueManager = issueManager;
        this.userPickerHelper = userPickerHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.columnService = columnService;
        this.beanFactory = beanFactory;
        this.updateUserApplicationHelper = updateUserApplicationHelper;
        this.responseFactory = responseFactory;
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarService, avatarPickerHelper, attachmentHelper, userManager);
        this.userUtil = userUtil;
        this.i18n = i18n;
        this.emailFormatter = emailFormatter;
        this.authContext = authContext;
        this.timeZoneManager = timeZoneManager;
        this.avatarService = avatarService;
        this.xsrfChecker = xsrfChecker;
        this.applicationRoleManager = applicationRoleManager;
        this.applicationRoleBeanConverter = applicationRoleBeanConverter;
    }

    @GET
    @ResponseType(value=UserBean.class)
    public Response getUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key) {
        if (this.authContext.getUser() == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        return Response.ok((Object)this.buildUserBean(name, key)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=List.class, genericTypes={UserBean.class})
    @Path(value="search")
    public Response findUsers(@QueryParam(value="username") String username, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="includeActive") Boolean includeActive, @QueryParam(value="includeInactive") Boolean includeInactive, @Context UriInfo uriInfo) {
        List<ApplicationUser> allResults = this.userPickerHelper.findUsers(username, includeActive, includeInactive);
        List<ApplicationUser> page = this.userPickerHelper.limitUserSearch(startAt, maxResults, allResults, null);
        return Response.ok(this.makeUserBeans(page)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=UserPickerResultsBean.class)
    @Path(value="picker")
    @AnonymousAllowed
    public Response findUsersForPicker(@QueryParam(value="query") String query, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="showAvatar") Boolean showAvatar, @QueryParam(value="exclude") List<String> excludeUsers) {
        return Response.ok((Object)this.userPickerHelper.findUsersAsBean(query, maxResults, showAvatar, excludeUsers)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=List.class, genericTypes={UserBean.class})
    @Path(value="assignable/search")
    public Response findAssignableUsers(@QueryParam(value="username") String name, @QueryParam(value="project") String projectKey, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="actionDescriptorId") Integer actionDescriptorId, @Context UriInfo uriInfo) {
        ActionDescriptor actionDescriptor = null;
        if (actionDescriptorId != null) {
            actionDescriptor = this.getActionDescriptorById(issueKey, actionDescriptorId);
        }
        List<ApplicationUser> usersWithPermission = this.findAssignableUsers(name, projectKey, issueKey, actionDescriptor, startAt, maxResults);
        return Response.ok(this.makeUserBeans(usersWithPermission)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequestType(value=UserWriteBean.class)
    @ResponseType(value=UserBean.class)
    @WebSudoRequired
    @ExperimentalApi
    public Response createUser(UserWriteBean userBean) {
        UserService.CreateUserValidationResult validationResult;
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        boolean sendNotification = userBean.getNotification() != null && Boolean.parseBoolean(userBean.getNotification());
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedUser, (String)userBean.getName(), (String)userBean.getPassword(), (String)userBean.getEmailAddress(), (String)userBean.getDisplayName()).confirmPassword(userBean.getPassword()).sendNotification(sendNotification);
        if (userBean.getApplicationKeys() != null) {
            ImmutableList applicationKeys = ImmutableList.copyOf((Iterable)Iterables.transform(userBean.getApplicationKeys(), (Function)ApplicationKeys.TO_APPLICATION_KEY));
            ImmutableList nonValidKeysMessages = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Eithers.filterLeft((Iterable)applicationKeys), input -> this.i18n.getText("application.role.rest.bad.key", input)));
            if (!nonValidKeysMessages.isEmpty()) {
                throw new BadRequestWebException(ErrorCollection.of((Collection<String>)nonValidKeysMessages));
            }
            createUserRequest = createUserRequest.withApplicationAccess((Set)ImmutableSet.copyOf((Iterable)Eithers.filterRight((Iterable)applicationKeys)));
        }
        if (!(validationResult = this.userService.validateCreateUser(createUserRequest)).isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        try {
            this.userService.createUser(validationResult);
            UserBean responseUserBean = this.buildUserBean(userBean.getName(), null);
            return Response.status((Response.Status)Response.Status.CREATED).location(responseUserBean.getSelf()).entity((Object)responseUserBean).cacheControl(CacheControl.never()).build();
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        catch (CreateException e) {
            throw new ServerErrorWebException(ErrorCollection.of(e.getLocalizedMessage()));
        }
    }

    @PUT
    @WebSudoRequired
    @ExperimentalApi
    @RequestType(value=UserWriteBean.class)
    @ResponseType(value=UserBean.class)
    public Response updateUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key, UserWriteBean userBean) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        if (StringUtils.isBlank((CharSequence)userBean.getName()) && StringUtils.isBlank((CharSequence)userBean.getEmailAddress()) && StringUtils.isBlank((CharSequence)userBean.getDisplayName()) && Objects.isNull(userBean.isActive())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.no.value.found.to.be.changed")));
        }
        if (StringUtils.length((CharSequence)userBean.getDisplayName()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "displayName", Integer.toString(255))));
        }
        if (StringUtils.length((CharSequence)userBean.getEmailAddress()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "emailAddress", Integer.toString(255))));
        }
        if (StringUtils.isNotBlank((CharSequence)userBean.getEmailAddress()) && !TextUtils.verifyEmail((String)userBean.getEmailAddress())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("admin.errors.invalid.email")));
        }
        ApplicationUser changedUser = this.getUserByUsernameOrKey(name, key);
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)changedUser.getDirectoryUser());
        userBuilder.name((String)StringUtils.defaultIfBlank((CharSequence)userBean.getName(), (CharSequence)changedUser.getName()));
        userBuilder.emailAddress((String)StringUtils.defaultIfBlank((CharSequence)userBean.getEmailAddress(), (CharSequence)changedUser.getEmailAddress()));
        userBuilder.displayName((String)StringUtils.defaultIfBlank((CharSequence)userBean.getDisplayName(), (CharSequence)changedUser.getDisplayName()));
        userBuilder.active(Optional.ofNullable(userBean.isActive()).orElse(changedUser.isActive()).booleanValue());
        UserService.UpdateUserValidationResult validationResult = this.userService.validateUpdateUser((ApplicationUser)new DelegatingApplicationUser(changedUser.getId(), changedUser.getKey(), userBuilder.toUser()));
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.userService.updateUser(validationResult);
        return Response.ok((Object)this.buildUserBean(null, changedUser.getKey())).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="password")
    @ResponseType(value=Void.class)
    public Response changeUserPassword(@QueryParam(value="username") String name, @QueryParam(value="key") String key, PasswordBean passwordBean) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        ApplicationUser changedUser = this.getUserByUsernameOrKey(name, key);
        this.nonSysAdminCannotModifySysAdmin(loggedUser, changedUser);
        String password = passwordBean.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.required")));
        }
        Collection messages = this.passwordPolicyManager.checkPolicy(changedUser, null, password);
        if (!messages.isEmpty()) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        try {
            this.userUtil.changePassword(changedUser, password);
        }
        catch (UserNotFoundException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.could.not.find.user")));
        }
        catch (InvalidCredentialException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        catch (OperationNotPermittedException | PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("admin.errors.cannot.edit.user.directory.read.only")));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @ExperimentalApi
    public Response removeUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        ApplicationUser removedUser = this.getUserByUsernameOrKey(name, key);
        UserService.DeleteUserValidationResult validationResult = this.userService.validateDeleteUser(loggedUser, removedUser);
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        try {
            this.userService.removeUser(loggedUser, validationResult);
        }
        catch (Exception e) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void mustBeAdmin(ApplicationUser user) {
        if (user == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        boolean isGlobalAdmin = this.permissionManager.hasPermission(0, user);
        if (!isGlobalAdmin) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required")));
        }
    }

    private void nonSysAdminCannotModifySysAdmin(ApplicationUser loggedUser, ApplicationUser changedUser) {
        boolean isSystemAdminLogged = this.permissionManager.hasPermission(44, loggedUser);
        boolean isSystemAdminEdited = this.permissionManager.hasPermission(44, changedUser);
        if (isSystemAdminEdited && !isSystemAdminLogged) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
    }

    protected ActionDescriptor getActionDescriptorById(String issueKey, Integer actionDescriptorId) {
        WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
        workflowTransitionUtil.setIssue(this.issueManager.getIssueObject(issueKey));
        workflowTransitionUtil.setAction(actionDescriptorId.intValue());
        return workflowTransitionUtil.getActionDescriptor();
    }

    private List<ApplicationUser> findAssignableUsers(String name, String projectKey, String issueKey, ActionDescriptor actionDescriptor, Integer startAt, Integer maxResults) {
        if (startAt == null) {
            startAt = 0;
        }
        Predicate userFilter = null;
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)issueKey)) {
            IssueService.IssueResult issueResult = this.issueService.getIssue(loggedInUser, issueKey);
            if (!issueResult.isValid()) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(issueResult.getErrorCollection()));
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.ASSIGN_ISSUES, (Issue)issueResult.getIssue(), loggedInUser)) {
                throw new NotAuthorisedWebException();
            }
            userFilter = input -> this.assigneeService.isAssignable((Issue)issueResult.getIssue(), ApplicationUsers.from((User)input), actionDescriptor);
        } else if (StringUtils.isNotBlank((CharSequence)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.authContext.getI18nHelper().getText("rest.must.provide.valid.project")));
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.ASSIGN_ISSUES, project, loggedInUser)) {
                throw new NotAuthorisedWebException();
            }
            userFilter = input -> this.assigneeService.isAssignable(project, ApplicationUsers.from((User)input));
        } else {
            this.throwWebException(this.authContext.getI18nHelper().getText("rest.must.provide.project.or.issue"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Integer queryMax = maxResults == null ? Integer.valueOf(startAt + 50) : Integer.valueOf(startAt + maxResults);
        UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(true).includeInactive(false).allowEmptyQuery(true).filter(userFilter).maxResults(queryMax).ignorePermissionCheck(true).build();
        List<ApplicationUser> users = this.userPickerHelper.findUsers(name, userSearchParams);
        return this.userPickerHelper.limitUserSearch(startAt, maxResults, users, null);
    }

    @GET
    @ResponseType(value=List.class, genericTypes={UserBean.class})
    @Path(value="viewissue/search")
    public Response findUsersWithBrowsePermission(@QueryParam(value="username") String username, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @Context UriInfo uriInfo) {
        maxResults = this.verifyAndAdjustMaxResults(maxResults);
        startAt = this.verifyAndAdjustStartAt(startAt);
        Integer findUsersMax = startAt + maxResults;
        Either<Project, Issue> issueOrProject = this.getIssueOrProject(issueKey, projectKey);
        List<ApplicationUser> usersWithPermission = this.findUsersWithPermission((Iterable<Integer>)ImmutableList.of((Object)10), username, issueOrProject, false, findUsersMax);
        List<UserBean> userBeans = this.makeUserBeans(usersWithPermission);
        int fromIndex = Math.min(startAt, userBeans.size());
        int toIndex = Math.min(findUsersMax, userBeans.size());
        List<UserBean> responseBeans = userBeans.subList(fromIndex, toIndex);
        return Response.ok(responseBeans).cacheControl(CacheControl.never()).build();
    }

    @VisibleForTesting
    List<ApplicationUser> findUsersWithPermission(Iterable<Integer> permissions, String name, Either<Project, Issue> projectOrIssue, boolean allowEmptyQuery, Integer maxResults) {
        Predicate permissionPredicate = (Predicate)projectOrIssue.fold(project -> this.createProjectPredicate(permissions, (Project)project), issue -> this.createIssuePredicate(permissions, (Issue)issue));
        return this.userPickerHelper.findUsers(name, true, false, allowEmptyQuery, (Predicate<User>)permissionPredicate, maxResults);
    }

    @VisibleForTesting
    Either<Project, Issue> getIssueOrProject(String issueKey, String projectKey) {
        if (StringUtils.isNotBlank((CharSequence)issueKey)) {
            IssueService.IssueResult issueResult = this.issueService.getIssue(this.authContext.getUser(), issueKey);
            if (!issueResult.isValid()) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(issueResult.getErrorCollection()));
            }
            return Either.right((Object)issueResult.getIssue());
        }
        if (StringUtils.isNotBlank((CharSequence)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.authContext.getI18nHelper().getText("rest.must.provide.valid.project")));
            }
            return Either.left((Object)project);
        }
        throw this.createWebException(this.authContext.getI18nHelper().getText("rest.must.provide.project.or.issue"), ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @VisibleForTesting
    Predicate<User> createProjectPredicate(Iterable<Integer> permissions, Project project) {
        return user -> {
            for (Integer permission : permissions) {
                if (this.permissionManager.hasPermission(new ProjectPermissionKey(permission.intValue()), project, ApplicationUsers.from((User)user), true)) continue;
                return false;
            }
            return true;
        };
    }

    @VisibleForTesting
    Predicate<User> createIssuePredicate(Iterable<Integer> permissions, Issue issue) {
        return user -> {
            for (Integer permission : permissions) {
                if (this.permissionManager.hasPermission(permission.intValue(), issue, ApplicationUsers.from((User)user))) continue;
                return false;
            }
            return true;
        };
    }

    private Integer verifyAndAdjustMaxResults(Integer maxResults) {
        if (maxResults == null) {
            return 50;
        }
        if (maxResults > 1000) {
            return 1000;
        }
        if (maxResults < 0) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.negative.maxresults", (Object)maxResults));
        }
        return maxResults;
    }

    private Integer verifyAndAdjustStartAt(Integer startAt) {
        if (startAt == null) {
            return 0;
        }
        if (startAt < 0) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.negative.startat", (Object)startAt));
        }
        return startAt;
    }

    @GET
    @ResponseType(value=List.class, genericTypes={UserBean.class})
    @Path(value="permission/search")
    public Response findUsersWithAllPermissions(@QueryParam(value="username") String name, @QueryParam(value="permissions") String permissions, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults) {
        if (StringUtils.isBlank((CharSequence)permissions)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.missing.permission.string"));
        }
        maxResults = this.verifyAndAdjustMaxResults(maxResults);
        startAt = this.verifyAndAdjustStartAt(startAt);
        Either<Project, Issue> issueOrProject = this.getIssueOrProject(issueKey, projectKey);
        Project project = (Project)issueOrProject.left().on(Issue::getProjectObject);
        ApplicationUser currentUser = this.authContext.getUser();
        if (!(this.permissionManager.hasPermission(44, currentUser) || this.permissionManager.hasPermission(0, currentUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, currentUser))) {
            throw new ForbiddenWebException();
        }
        ImmutableList<Integer> permissionIds = this.parsePermissions(permissions);
        Integer maxResultsForQuery = startAt + maxResults;
        List<ApplicationUser> usersWithPermission = this.findUsersWithPermission((Iterable<Integer>)permissionIds, name, issueOrProject, true, maxResultsForQuery);
        List<ApplicationUser> page = this.userPickerHelper.limitUserSearch(startAt, maxResults, usersWithPermission, null);
        return Response.ok(this.makeUserBeans(page)).cacheControl(CacheControl.never()).build();
    }

    @VisibleForTesting
    ImmutableList<Integer> parsePermissions(String permissions) {
        ImmutableList requestedPermissions = ImmutableList.copyOf((Object[])StringUtils.split((String)permissions, (String)","));
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)requestedPermissions, permission -> {
            try {
                return Permissions.Permission.valueOf((String)permission).getId();
            }
            catch (IllegalArgumentException e) {
                throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.invalid.permission.string", permission));
            }
        }));
    }

    @GET
    @ResponseType(value=List.class, genericTypes={UserBean.class})
    @Path(value="assignable/multiProjectSearch")
    @AnonymousAllowed
    public Response findBulkAssignableUsers(@QueryParam(value="username") String name, @QueryParam(value="projectKeys") String projectKeysStr, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @Context UriInfo uriInfo) {
        if (StringUtils.isBlank((CharSequence)projectKeysStr)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.missing.field", "projectKeys"));
        }
        String[] projectKeys = projectKeysStr.split(",");
        ArrayList<Project> projects = new ArrayList<Project>(projectKeys.length);
        for (String projectKey : projectKeys) {
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authContext.getUser(), projectKey, ProjectAction.VIEW_PROJECT);
            if (projectResult.getErrorCollection().hasAnyErrors()) {
                ErrorCollection errors = ErrorCollection.of(projectResult.getErrorCollection());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.ASSIGN_ISSUES, projectResult.getProject(), this.authContext.getLoggedInUser())) continue;
            projects.add(projectResult.getProject());
        }
        Predicate filter = input -> {
            for (Project project : projects) {
                if (!this.assigneeService.isAssignable(project, ApplicationUsers.from((User)input))) continue;
                return true;
            }
            return false;
        };
        Integer maxResultsRequired = startAt != null && maxResults != null ? Integer.valueOf(startAt + maxResults) : maxResults;
        UserSearchParams userSearchParams = UserSearchParams.builder().allowEmptyQuery(true).filter(filter).maxResults(maxResultsRequired).ignorePermissionCheck(true).build();
        List<ApplicationUser> page = this.userPickerHelper.findUsers(name, userSearchParams);
        page = this.userPickerHelper.limitUserSearch(startAt, maxResults, page, null);
        return Response.ok(this.makeUserBeans(page)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=Map.class, genericTypes={String.class, AvatarBean[].class})
    @Path(value="avatars")
    public Map<String, List<AvatarBean>> getAllAvatars(@QueryParam(value="username") String name) {
        ApplicationUser user = this.getApplicationUser(name);
        Long selectedAvatarId = null;
        Avatar selectedAvatar = this.avatarService.getAvatar(this.authContext.getUser(), user);
        if (selectedAvatar != null) {
            selectedAvatarId = selectedAvatar.getId();
        }
        return this.avatarResourceHelper.getAllAvatars(IconType.USER_ICON_TYPE, user.getKey(), selectedAvatarId);
    }

    @POST
    @ResponseType(value=AvatarBean.class)
    @Path(value="avatar")
    @AnonymousAllowed
    public Response createAvatarFromTemporary(@QueryParam(value="username") String username, AvatarCroppingBean croppingInstructions) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.createAvatarFromTemporary(IconType.USER_ICON_TYPE, user.getKey(), croppingInstructions);
    }

    @PUT
    @RequestType(value=AvatarBean.class)
    @Path(value="avatar")
    @ResponseType(value=Void.class)
    @AnonymousAllowed
    public Response updateProjectAvatar(@QueryParam(value="username") String username, AvatarBean avatarBean) {
        Long avatarId;
        ApplicationUser userObject = this.getApplicationUser(username);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(userObject);
        String id = avatarBean.getId();
        try {
            avatarId = id == null ? null : Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            avatarId = null;
        }
        if (!this.avatarManager.hasPermissionToEdit(this.authContext.getUser(), userObject)) {
            throw new NotAuthorisedWebException();
        }
        propertySet.setLong("user.avatar.id", avatarId.longValue());
        this.eventPublisher.publish((Object)new UserAvatarUpdatedEvent(userObject, avatarId));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @ResponseType(value=AvatarCroppingBean.class)
    @Consumes(value={"*/*"})
    @Path(value="avatar/temporary")
    @AnonymousAllowed
    public Response storeTemporaryAvatar(@QueryParam(value="username") String username, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.storeTemporaryAvatar(IconType.USER_ICON_TYPE, user.getKey(), filename, size, request);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="avatar/temporary")
    @Produces(value={"text/html"})
    @ResponseType(value=AvatarCroppingBean.class)
    @AnonymousAllowed
    public Response storeTemporaryAvatarUsingMultiPart(@QueryParam(value="username") String username, @MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.USER_ICON_TYPE, user.getKey(), filePart, request);
    }

    @DELETE
    @Path(value="avatar/{id}")
    @AnonymousAllowed
    public Response deleteAvatar(@QueryParam(value="username") String username, @PathParam(value="id") Long id) {
        this.getApplicationUser(username);
        return this.avatarResourceHelper.deleteAvatar(id);
    }

    @GET
    @Path(value="columns")
    @ResponseType(value=List.class, genericTypes={ColumnOptions.ColumnItem.class})
    public Response defaultColumns(@QueryParam(value="username") String username) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceOutcome outcome = this.columnService.getColumnLayout(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username));
        if (outcome.isValid()) {
            List columnLayoutItems = ((ColumnLayout)outcome.getReturnedValue()).getColumnLayoutItems();
            return Response.ok(ColumnOptions.toColumnOptions(columnLayoutItems)).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="columns")
    @Consumes(value={"*/*"})
    @ResponseType(value=Void.class)
    @AnonymousAllowed
    public Response setColumns(@FormParam(value="username") String username, @FormParam(value="columns") List<String> fields) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username), fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @DELETE
    @Path(value="columns")
    @Consumes(value={"*/*"})
    public Response resetColumns(@QueryParam(value="username") String username) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceResult outcome = this.columnService.resetColumns(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username));
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @POST
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="application")
    @ResponseType(value=Void.class)
    public Response addUserToApplication(@QueryParam(value="username") String username, @QueryParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.addUserToApplication(username, applicationKey);
        if (!applicationUpdateResult.isValid()) {
            return this.responseFactory.errorResponse(applicationUpdateResult.getErrorCollection());
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="application")
    public Response removeUserFromApplication(@QueryParam(value="username") String username, @QueryParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.removeUserFromApplication(username, applicationKey);
        if (!applicationUpdateResult.isValid()) {
            return this.responseFactory.errorResponse(applicationUpdateResult.getErrorCollection());
        }
        return this.responseFactory.noContent();
    }

    private UserBean buildUserBean(String name, String key) {
        ApplicationUser user = this.getUserByUsernameOrKey(name, key);
        UserBeanBuilder builder = new UserBeanBuilder(this.jiraBaseUrls).user(user).groups(new ArrayList<String>(this.userUtil.getGroupNamesForUser(user.getUsername()))).loggedInUser(this.authContext.getUser()).emailFormatter(this.emailFormatter).timeZone(this.timeZoneManager.getTimeZoneforUser(user)).avatarService(this.avatarService).i18nBeanFactory(this.beanFactory).applicationRoles(this.applicationRoleManager.getRolesForUser(user));
        return builder.buildFull(this.applicationRoleBeanConverter);
    }

    private ApplicationUser getUserByUsernameOrKey(String name, String key) {
        ApplicationUser user;
        if (name == null) {
            if (key == null) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.or.key.param")));
            }
            user = this.userUtil.getUserByKey(key);
        } else {
            if (key != null) {
                throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.too.many.params")));
            }
            user = this.userUtil.getUserByName(name);
        }
        if (user == null) {
            if (name != null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found", name)));
            }
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found.with.key", key)));
        }
        return user;
    }

    private ApplicationUser getApplicationUser(String name) {
        if (name == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.param")));
        }
        ApplicationUser user = this.userUtil.getUserByName(name);
        if (user == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found", name)));
        }
        return user;
    }

    private List<UserBean> makeUserBeans(Collection<ApplicationUser> users) {
        ArrayList<UserBean> beans = new ArrayList<UserBean>(users.size());
        for (ApplicationUser user : users) {
            UserBeanBuilder builder = new UserBeanBuilder(this.jiraBaseUrls).user(user).loggedInUser(this.authContext.getUser()).emailFormatter(this.emailFormatter).timeZone(this.timeZoneManager.getTimeZoneforUser(user)).i18nBeanFactory(this.beanFactory);
            beans.add(builder.buildMid());
        }
        return beans;
    }

    private void throwWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private RESTException createWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        return new RESTException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
    }
}

