/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.util.JiraUrlCodec;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resolution")
public class ResolutionBean {
    static final ResolutionBean DOC_EXAMPLE;
    static final ResolutionBean DOC_EXAMPLE_2;
    static final List<ResolutionBean> DOC_EXAMPLE_LIST;
    @XmlElement
    private URI self;
    @XmlElement
    private String description;
    @XmlElement
    private String iconUrl;
    @XmlElement
    private String name;
    @XmlElement
    private String id;

    public static ResolutionBean shortBean(Resolution resolution, JiraBaseUrls urls) {
        ResolutionBean bean = new ResolutionBean();
        bean.self = URI.create(urls.restApi2BaseUrl() + "resolution/" + JiraUrlCodec.encode((String)resolution.getId()));
        bean.name = resolution.getNameTranslation();
        bean.id = resolution.getId();
        return bean;
    }

    public static ResolutionBean fullBean(Resolution resolution, JiraBaseUrls urls) {
        ResolutionBean bean = ResolutionBean.shortBean(resolution, urls);
        bean.description = resolution.getDescTranslation();
        return bean;
    }

    public static Collection<ResolutionBean> asBeans(Collection<? extends Resolution> priorities, JiraBaseUrls urls, String baseUrl) {
        ArrayList<ResolutionBean> list = new ArrayList<ResolutionBean>(priorities.size());
        for (Resolution resolution : priorities) {
            list.add(ResolutionBean.shortBean(resolution, urls));
        }
        return list;
    }

    static {
        ResolutionBean resolution = new ResolutionBean();
        resolution.self = Examples.restURI("resolution/1");
        resolution.name = "Fixed";
        resolution.description = "A fix for this issue is checked into the tree and tested.";
        resolution.iconUrl = Examples.jiraURI("images/icons/statuses/resolved.png").toString();
        DOC_EXAMPLE = resolution;
        resolution = new ResolutionBean();
        resolution.self = Examples.restURI("resolution/3");
        resolution.name = "Works as designed";
        resolution.description = "This is what it is supposed to do.";
        DOC_EXAMPLE_2 = resolution;
        DOC_EXAMPLE_LIST = EasyList.build((Object)DOC_EXAMPLE, (Object)DOC_EXAMPLE_2);
    }
}

