/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="projectvalidate")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectValidateResource {
    public static final ErrorCollection DOC_EXAMPLE;
    private ProjectService projectService;
    private JiraAuthenticationContext authContext;

    private ProjectValidateResource() {
    }

    public ProjectValidateResource(ProjectService projectService, JiraAuthenticationContext authContext) {
        this.projectService = projectService;
        this.authContext = authContext;
    }

    @GET
    @ResponseType(value=ErrorCollection.class)
    @Path(value="key")
    public Response getProject(@QueryParam(value="key") String key) {
        JiraServiceContext context = this.getContext();
        this.projectService.isValidProjectKey(context, key);
        ErrorCollection errors = ErrorCollection.of(context.getErrorCollection());
        return Response.ok((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private JiraServiceContext getContext() {
        return new JiraServiceContextImpl(this.authContext.getUser());
    }

    static {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addError("projectKey", "A project with that project key already exists.");
        DOC_EXAMPLE = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors);
    }
}

