/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.IssueLinkTypeFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.LinkIssueRequestJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="issueLink")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LinkIssueResource {
    private final ApplicationProperties applicationProperties;
    private final I18nHelper i18n;
    private final JiraBaseUrls jiraBaseUrls;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final IssueLinkManager issueLinkManager;
    private final CommentService commentService;
    private final ProjectRoleManager projectRoleManager;
    private final IssueLinkTypeFinder issueLinkTypeFinder;
    private final IssueFinder issueFinder;
    private final IssueLinkService issueLinkService;
    private final IssueService issueService;
    private static final Logger log = LoggerFactory.getLogger(LinkIssueResource.class);

    public LinkIssueResource(ApplicationProperties applicationProperties, I18nHelper i18n, JiraAuthenticationContext authContext, PermissionManager permissionManager, IssueLinkManager issueLinkManager, CommentService commentService, ProjectRoleManager projectRoleManager, IssueLinkTypeFinder issueLinkTypeFinder, IssueFinder issueFinder, IssueLinkService issueLinkService, JiraBaseUrls jiraBaseUrls, IssueService issueService) {
        this.applicationProperties = applicationProperties;
        this.i18n = i18n;
        this.jiraBaseUrls = jiraBaseUrls;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.issueLinkManager = issueLinkManager;
        this.commentService = commentService;
        this.projectRoleManager = projectRoleManager;
        this.issueLinkTypeFinder = issueLinkTypeFinder;
        this.issueFinder = issueFinder;
        this.issueLinkService = issueLinkService;
        this.issueService = issueService;
    }

    @POST
    @ResponseType(value=Void.class)
    public Response linkIssues(LinkIssueRequestJsonBean linkIssueRequestBean) {
        Long issueLinkId;
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.issuelinking.status", this.i18n.getText("admin.common.words.disabled"))));
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        IssueLinkType linkType = this.issueLinkTypeFinder.findIssueLinkType(linkIssueRequestBean.getType(), (com.atlassian.jira.util.ErrorCollection)errors);
        Issue inwardIssue = this.issueFinder.findIssue(linkIssueRequestBean.inwardIssue(), (com.atlassian.jira.util.ErrorCollection)errors);
        Issue outwardIssue = this.issueFinder.findIssue(linkIssueRequestBean.outwardIssue(), (com.atlassian.jira.util.ErrorCollection)errors);
        if (linkType == null || inwardIssue == null || outwardIssue == null) {
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors));
        }
        if (inwardIssue.getKey().equalsIgnoreCase(outwardIssue.getKey())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("issuelinking.service.error.self.reference")));
        }
        if (!this.permissionManager.hasPermission(21, inwardIssue, this.authContext.getUser())) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.issue.link.error.link.no.link.permission", inwardIssue.getKey())));
        }
        if (errors.hasAnyErrors()) {
            throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors));
        }
        CommentJsonBean commentBean = linkIssueRequestBean.getComment();
        if (commentBean != null) {
            VisibilityJsonBean visibility = commentBean.getVisibility();
            if (visibility != null) {
                this.validateVisibilityRole(visibility);
                this.validateVisibilityGroup(inwardIssue, commentBean, visibility);
            }
            this.validateCommentBody(commentBean);
        }
        try {
            this.issueLinkManager.createIssueLink(inwardIssue.getId(), outwardIssue.getId(), linkType.getId(), null, this.authContext.getUser());
            issueLinkId = this.issueLinkManager.getIssueLink(inwardIssue.getId(), outwardIssue.getId(), linkType.getId()).getId();
        }
        catch (CreateException e) {
            throw new RESTException(Response.Status.INTERNAL_SERVER_ERROR, e);
        }
        if (commentBean != null && commentBean.getBody() != null) {
            this.createComment(inwardIssue, outwardIssue, commentBean);
        }
        URI issueLinkSelfURI = URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issueLink/" + issueLinkId.toString());
        return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)issueLinkSelfURI.toString()).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=IssueLinkJsonBean.class)
    @Path(value="{linkId}")
    public Response getIssueLink(@PathParam(value="linkId") String linkId) {
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.issuelinking.status", this.i18n.getText("admin.common.words.disabled"))));
        }
        if (StringUtils.isBlank((CharSequence)linkId)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.issue.link.no.id")));
        }
        try {
            Long.valueOf(linkId);
        }
        catch (NumberFormatException ex) {
            throw new BadRequestWebException(ex, ErrorCollection.of(this.i18n.getText("rest.issue.link.invalid.id", linkId)));
        }
        IssueLinkService.SingleIssueLinkResult issueLinkResult = this.issueLinkService.getIssueLink(Long.valueOf(linkId), this.authContext.getUser());
        if (!issueLinkResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(issueLinkResult.getErrorCollection()));
        }
        IssueLink issueLink = issueLinkResult.getIssueLink();
        IssueService.IssueResult sourceIssueResult = this.issueService.getIssue(this.authContext.getUser(), issueLink.getSourceId());
        IssueService.IssueResult destinationIssueResult = this.issueService.getIssue(this.authContext.getUser(), issueLink.getDestinationId());
        if (!sourceIssueResult.isValid() || !destinationIssueResult.isValid()) {
            sourceIssueResult.getErrorCollection().getErrors().putAll(destinationIssueResult.getErrorCollection().getErrors());
            sourceIssueResult.getErrorCollection().getErrorMessages().addAll(destinationIssueResult.getErrorCollection().getErrorMessages());
            throw new NotFoundWebException(ErrorCollection.of(sourceIssueResult.getErrorCollection()));
        }
        IssueLinkBeanBuilder issueLinkBeanBuilder = new IssueLinkBeanBuilder(this.jiraBaseUrls);
        IssueLinkJsonBean issueLinkJsonBean = issueLinkBeanBuilder.buildIssueLinkBean(issueLink.getIssueLinkType(), issueLink.getId().toString());
        issueLinkJsonBean.outwardIssue(issueLinkBeanBuilder.createIssueRefJsonBean((Issue)destinationIssueResult.getIssue()));
        issueLinkJsonBean.inwardIssue(issueLinkBeanBuilder.createIssueRefJsonBean((Issue)sourceIssueResult.getIssue()));
        return Response.ok((Object)issueLinkJsonBean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{linkId}")
    public Response deleteIssueLink(@PathParam(value="linkId") String linkId) {
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.issuelinking.status", this.i18n.getText("admin.common.words.disabled"))));
        }
        if (StringUtils.isBlank((CharSequence)linkId)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.issue.link.no.id")));
        }
        try {
            Long.valueOf(linkId);
        }
        catch (NumberFormatException ex) {
            throw new BadRequestWebException(ex, ErrorCollection.of(this.i18n.getText("rest.issue.link.invalid.id", linkId)));
        }
        log.warn("My classloader: " + this.getClass().getClassLoader());
        log.warn("IssueLinkService classloader: " + this.issueLinkService.getClass().getClassLoader());
        log.warn("IssueLinkService" + this.issueLinkService);
        IssueLinkService.SingleIssueLinkResult issueLinkResult = this.issueLinkService.getIssueLink(Long.valueOf(linkId), this.authContext.getUser());
        if (!issueLinkResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(issueLinkResult.getErrorCollection()));
        }
        IssueLink issueLink = issueLinkResult.getIssueLink();
        IssueService.IssueResult sourceIssueResult = this.issueService.getIssue(this.authContext.getUser(), issueLink.getSourceId());
        IssueService.IssueResult destinationIssueResult = this.issueService.getIssue(this.authContext.getUser(), issueLink.getDestinationId());
        if (!sourceIssueResult.isValid() || !destinationIssueResult.isValid()) {
            sourceIssueResult.getErrorCollection().getErrors().putAll(destinationIssueResult.getErrorCollection().getErrors());
            sourceIssueResult.getErrorCollection().getErrorMessages().addAll(destinationIssueResult.getErrorCollection().getErrorMessages());
            throw new NotFoundWebException(ErrorCollection.of(sourceIssueResult.getErrorCollection()));
        }
        IssueLinkService.DeleteIssueLinkValidationResult deleteSourceIssueLinkValidationResult = this.issueLinkService.validateDelete(this.authContext.getUser(), (Issue)sourceIssueResult.getIssue(), issueLink);
        if (deleteSourceIssueLinkValidationResult.isValid()) {
            this.issueLinkService.delete(deleteSourceIssueLinkValidationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        IssueLinkService.DeleteIssueLinkValidationResult deleteDesinationIssueLinkValidationResult = this.issueLinkService.validateDelete(this.authContext.getUser(), (Issue)destinationIssueResult.getIssue(), issueLink);
        if (deleteDesinationIssueLinkValidationResult.isValid()) {
            this.issueLinkService.delete(deleteDesinationIssueLinkValidationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        deleteSourceIssueLinkValidationResult.getErrorCollection().getErrors().putAll(deleteDesinationIssueLinkValidationResult.getErrorCollection().getErrors());
        deleteSourceIssueLinkValidationResult.getErrorCollection().getErrorMessages().addAll(deleteDesinationIssueLinkValidationResult.getErrorCollection().getErrorMessages());
        throw new NotAuthorisedWebException(ErrorCollection.of(deleteSourceIssueLinkValidationResult.getErrorCollection()));
    }

    private void createComment(Issue fromIssue, Issue toIssue, CommentJsonBean commentBean) {
        Comment comment;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (commentBean.getVisibility() != null) {
            String group;
            Long role;
            VisibilityJsonBean visibility = commentBean.getVisibility();
            if (visibility.type == VisibilityJsonBean.VisibilityType.role) {
                role = this.projectRoleManager.getProjectRole(visibility.value).getId();
                group = null;
            } else {
                group = visibility.value;
                role = null;
            }
            comment = this.commentService.create(this.authContext.getUser(), fromIssue, commentBean.getBody(), group, role, false, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        } else {
            comment = this.commentService.create(this.authContext.getUser(), fromIssue, commentBean.getBody(), false, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        }
        if (errorCollection.hasAnyErrors() || comment == null) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.issue.link.error.comment", toIssue.getKey()));
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    private void validateCommentBody(CommentJsonBean commentBean) {
        if (commentBean.getBody() != null) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.commentService.isValidCommentBody(commentBean.getBody(), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
        }
    }

    private void validateVisibilityGroup(Issue fromIssue, CommentJsonBean commentBean, VisibilityJsonBean visibility) {
        if (visibility.type == VisibilityJsonBean.VisibilityType.group) {
            if (visibility.value == null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.visibility.no.value")));
            }
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.commentService.isValidAllCommentData(this.authContext.getUser(), fromIssue, commentBean.getBody(), visibility.value, null, (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
        }
    }

    private void validateVisibilityRole(VisibilityJsonBean visibility) {
        if (visibility.type == VisibilityJsonBean.VisibilityType.role) {
            if (visibility.value == null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.visibility.no.value")));
            }
            Long roleId = this.projectRoleManager.getProjectRole(visibility.value).getId();
            if (roleId == null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.issue.link.error.project.role.not.found", visibility.value)));
            }
        }
    }
}

