/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.rest.json.beans.AssociateProjectsBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeSchemeCreateUpdateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.EndpointUsageEvent;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeListBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="issuetypescheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeSchemeResource {
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssueTypeService issueTypeService;
    private final ResponseFactory responseFactory;
    private final OptionSetManager optionSetManager;
    private final ProjectBeanFactory projectBeanFactory;
    private final IssueTypeSchemeService issueTypeSchemeService;
    private final EventPublisher eventPublisher;

    public IssueTypeSchemeResource(JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, IssueTypeService issueTypeService, ResponseFactory responseFactory, OptionSetManager optionSetManager, ProjectBeanFactory projectBeanFactory, IssueTypeSchemeService issueTypeSchemeService, EventPublisher eventPublisher) {
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueTypeService = issueTypeService;
        this.responseFactory = responseFactory;
        this.optionSetManager = optionSetManager;
        this.projectBeanFactory = projectBeanFactory;
        this.issueTypeSchemeService = issueTypeSchemeService;
        this.eventPublisher = eventPublisher;
    }

    @POST
    @RequestType(value=IssueTypeSchemeCreateUpdateBean.class)
    @ResponseType(value=IssueTypeSchemeBean.class)
    public Response createIssueTypeScheme(IssueTypeSchemeCreateUpdateBean createBean) {
        ServiceOutcome result = this.issueTypeSchemeService.createIssueTypeScheme(this.authContext.getLoggedInUser(), createBean.getName(), createBean.getDescription(), createBean.getIssueTypeIds(), createBean.getDefaultIssueTypeId());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.createScheme", true);
            return this.responseFactory.okNoCache(this.schemeToFullyExpandedBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.createScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @ResponseType(value=IssueTypeSchemeListBean.class)
    public Response getAllIssueTypeSchemes() {
        ServiceOutcome result = this.issueTypeSchemeService.getAllIssueTypeSchemes(this.authContext.getLoggedInUser());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getAllSchemes", true);
            IssueTypeSchemeListBean schemesList = new IssueTypeSchemeListBean(((List)result.get()).stream().map(this::schemeToBean).collect(Collectors.toList()));
            return this.responseFactory.okNoCache(schemesList);
        }
        this.publishAnalytics("issuetypescheme.getAllSchemes", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @ResponseType(value=IssueTypeSchemeBean.class)
    @Path(value="{schemeId}")
    public Response getIssueTypeScheme(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.getIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getScheme", true);
            return this.responseFactory.okNoCache(this.schemeToBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.getScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @PUT
    @Path(value="{schemeId}")
    @RequestType(value=IssueTypeSchemeCreateUpdateBean.class)
    @ResponseType(value=IssueTypeSchemeBean.class)
    public Response updateIssueTypeScheme(@PathParam(value="schemeId") String schemeId, IssueTypeSchemeCreateUpdateBean updateBean) {
        ServiceOutcome result = this.issueTypeSchemeService.updateIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId, updateBean.getName(), updateBean.getDescription(), updateBean.getIssueTypeIds(), updateBean.getDefaultIssueTypeId());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.updateScheme", true);
            return this.responseFactory.okNoCache(this.schemeToFullyExpandedBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.updateScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response deleteIssueTypeScheme(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.deleteIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.deleteScheme", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.deleteScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @POST
    @Path(value="{schemeId}/associations")
    @RequestType(value=AssociateProjectsBean.class)
    @ResponseType(value=Void.class)
    public Response addProjectAssociationsToScheme(@PathParam(value="schemeId") String schemeId, AssociateProjectsBean assocProjects) throws SearchException {
        ServiceOutcome result = this.issueTypeSchemeService.addProjectAssociations(this.authContext.getLoggedInUser(), schemeId, assocProjects.getIdsOrKeys());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.addProjectAssociations", true);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        this.publishAnalytics("issuetypescheme.addProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ProjectBean.class})
    @Path(value="{schemeId}/associations")
    public Response getAssociatedProjects(@PathParam(value="schemeId") String schemeId, @QueryParam(value="expand") String expand) {
        ServiceOutcome result = this.issueTypeSchemeService.getAssociatedProjects(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getProjectAssociations", true);
            return this.responseFactory.okNoCache(((List)result.get()).stream().map(proj -> this.projectBeanFactory.fullProject((Project)proj, StringUtils.defaultString((String)expand))).collect(Collectors.toList()));
        }
        this.publishAnalytics("issuetypescheme.getProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @PUT
    @Path(value="{schemeId}/associations")
    @RequestType(value=AssociateProjectsBean.class)
    @ResponseType(value=Void.class)
    public Response setProjectAssociationsForScheme(@PathParam(value="schemeId") String schemeId, AssociateProjectsBean assocProjects) throws SearchException {
        ServiceOutcome result = this.issueTypeSchemeService.setProjectAssociations(this.authContext.getLoggedInUser(), schemeId, assocProjects.getIdsOrKeys());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.setProjectAssociations", true);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        this.publishAnalytics("issuetypescheme.setProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}/associations")
    public Response removeAllProjectAssociations(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.removeAllProjectAssociations(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.removeAllProjectAssociations", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.removeAllProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}/associations/{projIdOrKey}")
    public Response removeProjectAssociation(@PathParam(value="schemeId") String schemeId, @PathParam(value="projIdOrKey") String projIdOrKey) {
        ServiceOutcome result = this.issueTypeSchemeService.removeProjectAssociation(this.authContext.getLoggedInUser(), schemeId, projIdOrKey);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.removeProjectAssociation", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.removeProjectAssociation", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    private IssueTypeSchemeBean schemeToBean(FieldConfigScheme itScheme) {
        ApplicationUser user = this.authContext.getUser();
        IssueTypeSchemeBean bean = new IssueTypeSchemeBean();
        bean.setId(itScheme.getId().toString());
        bean.setSelf(this.jiraBaseUrls.restApi2BaseUrl() + "issuetypescheme/" + itScheme.getId());
        bean.setName(itScheme.getName());
        bean.setDescription(itScheme.getDescription());
        bean.setDefaultIssueTypeSupplier(() -> {
            IssueType defaultIT = this.issueTypeSchemeService.getDefaultIssueType(itScheme);
            return defaultIT == null ? null : IssueTypeJsonBean.shortBean((IssueType)defaultIT, (JiraBaseUrls)this.jiraBaseUrls);
        });
        bean.setIssueTypesSupplier(() -> {
            FieldConfig config = itScheme.getOneAndOnlyConfig();
            Collection options = this.optionSetManager.getOptionsForConfig(config).getOptions();
            return options.stream().map(o -> o.getId()).map(id -> this.issueTypeService.getIssueType(user, id)).map(itype -> IssueTypeJsonBean.shortBean((IssueType)((IssueType)itype.get()), (JiraBaseUrls)this.jiraBaseUrls)).collect(Collectors.toList());
        });
        return bean;
    }

    private IssueTypeSchemeBean schemeToFullyExpandedBean(FieldConfigScheme itScheme) {
        IssueTypeSchemeBean maybeExpanded = this.schemeToBean(itScheme);
        maybeExpanded.setIssueTypes((Collection<IssueTypeJsonBean>)maybeExpanded.getIssueTypesSupplier().get());
        maybeExpanded.setDefaultIssueType(maybeExpanded.getDefaultIssueTypeSupplier().get());
        return maybeExpanded;
    }

    private void publishAnalytics(String endpoint, boolean successfulUsage) {
        this.eventPublisher.publish((Object)new EndpointUsageEvent(endpoint, successfulUsage));
    }
}

