/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentsWithPaginationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogWithPaginationBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.AdhocNotificationServiceImpl;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.BulkOperationErrorResult;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.IssuePicker;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.entity.property.IssuePropertiesLoader;
import com.atlassian.jira.rest.v2.issue.ArchiveIssueResource;
import com.atlassian.jira.rest.v2.issue.AssignIssueResource;
import com.atlassian.jira.rest.v2.issue.CommentResource;
import com.atlassian.jira.rest.v2.issue.CreateIssueResource;
import com.atlassian.jira.rest.v2.issue.CreateMetaBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.DeleteIssueResource;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBean;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkResource;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.TransitionsMetaBean;
import com.atlassian.jira.rest.v2.issue.UpdateIssueResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.VoteBean;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.watcher.WatchersFinder;
import com.atlassian.jira.rest.v2.issue.worklog.IssueWorklogResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.mail.MailFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.rest.annotation.ResponseTypes;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="issue")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueResource {
    private static final int MAX_PAGE_SIZE = 1000;
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DARK_FEATURE_DISABLE_CREATE_META = "com.atlassian.jira.issue.dark.feature.createmeta.disable";
    private final IssueFinder issueFinder;
    private final UserManager userManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final JiraAuthenticationContext authContext;
    private final VoteService voteService;
    private final I18nHelper i18n;
    private final WatchersFinder watchersFinder;
    private final WatcherService watcherService;
    private final AdhocNotificationService notificationService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final ContextUriInfo contextUriInfo;
    private final AssignIssueResource assignIssueResource;
    private final CreateIssueResource createIssueResource;
    private final DeleteIssueResource deleteIssueResource;
    private final ArchiveIssueResource archiveIssueResource;
    private final UpdateIssueResource updateIssueResource;
    private final RemoteIssueLinkResource remoteIssueLinkResource;
    private final IssueWorklogResource issueWorklogResource;
    private final CommentResource commentResource;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssuePicker issuePicker;
    private final OrderByRequestParser orderByRequestParser;
    private final ResponseFactory responseFactory;
    private final IssuePropertiesLoader issuePropertiesLoader;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final FeatureManager featureManager;

    public IssueResource(JiraAuthenticationContext authContext, UserManager userManager, VoteService voteService, I18nHelper i18n, WatchersFinder watchersFinder, WatcherService watcherService, BeanBuilderFactory beanBuilderFactory, ContextUriInfo contextUriInfo, IssueFinder issueFinder, CreateIssueResource createIssueResource, UpdateIssueResource updateIssueResource, DeleteIssueResource deleteIssueResource, ArchiveIssueResource archiveIssueResource, RemoteIssueLinkResource remoteIssueLinkResource, IssueWorklogResource issueWorklogResource, CommentResource commentResource, IssueWorkflowManager issueWorkflowManager, AssignIssueResource assignIssueResource, AdhocNotificationService notificationService, JiraBaseUrls jiraBaseUrls, IssuePicker issuePicker, OrderByRequestParser orderByRequestParser, ResponseFactory responseFactory, IssuePropertiesLoader issuePropertiesLoader, FeatureManager featureManager, UserIssueHistoryManager userIssueHistoryManager) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.issuePicker = issuePicker;
        this.orderByRequestParser = orderByRequestParser;
        this.responseFactory = responseFactory;
        this.issuePropertiesLoader = issuePropertiesLoader;
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((Object)authContext);
        this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        this.voteService = (VoteService)Assertions.notNull((Object)voteService);
        this.i18n = (I18nHelper)Assertions.notNull((Object)i18n);
        this.watchersFinder = (WatchersFinder)Assertions.notNull((Object)watchersFinder);
        this.watcherService = (WatcherService)Assertions.notNull((Object)watcherService);
        this.beanBuilderFactory = (BeanBuilderFactory)Assertions.notNull((Object)beanBuilderFactory);
        this.contextUriInfo = (ContextUriInfo)Assertions.notNull((Object)contextUriInfo);
        this.issueFinder = (IssueFinder)Assertions.notNull((Object)issueFinder);
        this.createIssueResource = (CreateIssueResource)Assertions.notNull((Object)createIssueResource);
        this.updateIssueResource = (UpdateIssueResource)Assertions.notNull((Object)updateIssueResource);
        this.deleteIssueResource = (DeleteIssueResource)Assertions.notNull((Object)deleteIssueResource);
        this.archiveIssueResource = (ArchiveIssueResource)Assertions.notNull((Object)archiveIssueResource);
        this.remoteIssueLinkResource = (RemoteIssueLinkResource)Assertions.notNull((Object)remoteIssueLinkResource);
        this.issueWorklogResource = (IssueWorklogResource)Assertions.notNull((Object)issueWorklogResource);
        this.commentResource = (CommentResource)Assertions.notNull((Object)commentResource);
        this.issueWorkflowManager = (IssueWorkflowManager)Assertions.notNull((Object)issueWorkflowManager);
        this.assignIssueResource = (AssignIssueResource)Assertions.notNull((Object)assignIssueResource);
        this.notificationService = (AdhocNotificationService)Assertions.notNull((Object)notificationService);
        this.userIssueHistoryManager = (UserIssueHistoryManager)Assertions.notNull((Object)userIssueHistoryManager);
        this.featureManager = (FeatureManager)Assertions.notNull((Object)featureManager);
    }

    @GET
    @Path(value="{issueIdOrKey}/transitions")
    @ResponseType(value=TransitionsMetaBean.class)
    public Response getTransitions(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="transitionId") String transitionId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        try {
            if (StringUtils.isNotBlank((CharSequence)transitionId)) {
                Integer.valueOf(transitionId);
            }
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        List actions = this.issueWorkflowManager.getSortedAvailableActions((Issue)issue, this.authContext.getUser());
        ArrayList<TransitionBean> transitions = new ArrayList<TransitionBean>(actions.size());
        for (ActionDescriptor action : actions) {
            if (StringUtils.isNotBlank((CharSequence)transitionId) && !Integer.valueOf(transitionId).equals(action.getId())) continue;
            TransitionBean transitionMetaBean = this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue((Issue)issue).action(action).build();
            transitions.add(transitionMetaBean);
        }
        TransitionsMetaBean transitionsMetaBean = new TransitionsMetaBean(transitions);
        return Response.ok((Object)transitionsMetaBean).cacheControl(CacheControl.never()).build();
    }

    @Path(value="picker")
    @GET
    @ResponseType(value=IssuePicker.IssuePickerResult.class)
    public Response getIssuePickerResource(@QueryParam(value="query") String query, @QueryParam(value="currentJQL") String currentJQL, @QueryParam(value="currentIssueKey") String currentIssueKey, @QueryParam(value="currentProjectId") String currentProjectId, @QueryParam(value="showSubTasks") boolean showSubTasks, @QueryParam(value="showSubTaskParent") boolean showSubTaskParent) {
        return this.issuePicker.getIssuesResponse((Option<String>)Option.option((Object)query), currentJQL, currentIssueKey, currentProjectId, showSubTasks, showSubTaskParent);
    }

    @POST
    @Path(value="{issueIdOrKey}/transitions")
    @RequestType(value=IssueUpdateBean.class)
    @ResponseType(value=Void.class)
    public Response doTransition(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueUpdateBean issueUpdateBean) {
        if (issueUpdateBean.getTransition() == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.no.transition"));
        }
        try {
            Integer.parseInt(issueUpdateBean.getTransition().getId());
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.updateIssueResource.transitionIssue((Issue)issue, issueUpdateBean);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/votes")
    public Response removeVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(this.authContext.getUser(), this.authContext.getUser(), (Issue)issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.removeVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @POST
    @Path(value="{issueIdOrKey}/votes")
    @ResponseType(value=Void.class)
    public Response addVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(this.authContext.getUser(), this.authContext.getUser(), (Issue)issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.addVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @GET
    @Path(value="{issueIdOrKey}/votes")
    @ResponseType(value=VoteBean.class)
    public Response getVotes(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        ApplicationUser user = this.authContext.getUser();
        if (this.voteService.isVotingEnabled()) {
            boolean hasVoted = this.voteService.hasVoted((Issue)issue, user);
            ServiceOutcome outcome = this.voteService.viewVoters((Issue)issue, user);
            ArrayList voters = outcome.isValid() ? new ArrayList(Transformed.collection((Collection)((Collection)outcome.getReturnedValue()), (Function)new Function<ApplicationUser, UserBean>(){

                public UserBean apply(ApplicationUser input) {
                    return new UserBeanBuilder(IssueResource.this.jiraBaseUrls).user(input).buildShort();
                }
            })) : new ArrayList();
            URI selfUri = this.contextUriInfo.getBaseUriBuilder().path(IssueResource.class).path(issue.getKey()).path("votes").build(new Object[0]);
            VoteBean voteBean = new VoteBean(selfUri, hasVoted, issue.getVotes(), voters);
            return Response.ok((Object)voteBean).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("issue.operations.voting.disabled")));
    }

    @GET
    @Path(value="{issueIdOrKey}")
    @ResponseType(value=IssueBean.class)
    public Response getIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand, @QueryParam(value="properties") List<StringList> properties, @QueryParam(value="updateHistory") boolean updateHistory) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        IncludedFields include = IncludedFields.includeAllByDefault(fields);
        IssueBeanBuilder2 issueBeanBuilder = this.beanBuilderFactory.newIssueBeanBuilder2(include, expand);
        IssueBean bean = issueBeanBuilder.build((Issue)issue);
        ApplicationUser user = this.authContext.getLoggedInUser();
        PropertiesBean propertiesBean = this.issuePropertiesLoader.getProperties(user, (Issue)issue, properties);
        bean.setProperties(propertiesBean);
        if (updateHistory && user != null) {
            this.userIssueHistoryManager.addIssueToHistory(user, (Issue)issue);
        }
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issueIdOrKey}/watchers")
    @ResponseType(value=WatchersBean.class)
    public Response getIssueWatchers(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        WatchersBean watchers = this.watchersFinder.getWatchers((Issue)issue, this.authContext.getUser());
        return Response.ok((Object)watchers).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{issueIdOrKey}/watchers")
    @ResponseType(value=Void.class)
    public Response addWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, String userName) {
        try {
            ApplicationUser watchUser = this.getUserFromPost(userName);
            if (watchUser == null) {
                return this.BAD_REQUEST();
            }
            MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.addWatcher((Issue)issue, this.authContext.getUser(), watchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException(e);
        }
    }

    private ApplicationUser getUserFromPost(String body) {
        if (StringUtils.isEmpty((CharSequence)body)) {
            return this.authContext.getUser();
        }
        JsonFactory factory = OBJECT_MAPPER.getJsonFactory();
        try {
            JsonParser jp = factory.createJsonParser(body);
            JsonNode obj = OBJECT_MAPPER.readTree(jp);
            if (obj.isTextual()) {
                String userName = obj.getTextValue();
                if (StringUtils.isEmpty((CharSequence)userName)) {
                    return this.authContext.getUser();
                }
                return this.userManager.getUser(userName);
            }
            throw new WebApplicationException(this.BAD_REQUEST());
        }
        catch (JsonParseException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @DELETE
    @Path(value="{issueIdOrKey}/watchers")
    public Response removeWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="username") String userName) {
        try {
            if (userName == null) {
                return this.BAD_REQUEST();
            }
            ApplicationUser unwatchUser = this.userManager.getUserEvenWhenUnknown(userName);
            MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.removeWatcher((Issue)issue, this.authContext.getUser(), unwatchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException();
        }
    }

    @POST
    @ResponseType(value=IssueCreateResponse.class)
    public Response createIssue(@QueryParam(value="updateHistory") @DefaultValue(value="false") boolean updateHistory, IssueUpdateBean createRequest) {
        return this.createIssueResource.createIssue(createRequest, updateHistory, this.contextUriInfo);
    }

    @POST
    @Path(value="/bulk")
    @ResponseTypes(value={@ResponseType(statusType=ResponseType.StatusType.SUCCESS, value=IssueCreateResponse.class), @ResponseType(statusType=ResponseType.StatusType.CLIENT_ERROR, value=BulkOperationErrorResult.class)})
    public Response createIssues(IssuesUpdateBean createRequest) {
        return this.createIssueResource.createIssues(createRequest, this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}")
    public Response deleteIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="deleteSubtasks") String deleteSubtasks) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.deleteIssueResource.deleteIssue((Issue)issue, deleteSubtasks, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/archive")
    @ResponseType(value=Void.class)
    public Response archiveIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.archiveIssueResource.archiveIssue(issue.getKey(), notifyUsers);
    }

    @POST
    @Path(value="archive")
    @Produces(value={"text/plain"})
    @ResponseType(value=StreamingOutput.class)
    public Response archiveIssues(@RequestBody List<String> issueKeys, @QueryParam(value="notifyUsers") @DefaultValue(value="false") boolean notifyUsers) {
        StreamingOutput streamingOutput = output -> {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (String issueKey : issueKeys) {
                Response response = this.archiveIssueResource.archiveIssue(issueKey, notifyUsers);
                writer.write(String.format("%s, %d %s\n", issueKey, response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus())));
                writer.flush();
            }
        };
        return Response.ok((Object)streamingOutput).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}/restore")
    @ResponseType(value=Void.class)
    public Response restoreIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.archiveIssueResource.restoreIssue(issue.getKey(), notifyUsers);
    }

    @GET
    @Deprecated
    @Path(value="createmeta")
    @ResponseType(value=CreateMetaBean.class)
    public Response getCreateIssueMeta(@QueryParam(value="projectIds") List<StringList> projectIds, @QueryParam(value="projectKeys") List<StringList> projectKeys, @QueryParam(value="issuetypeIds") List<StringList> issuetypeIds, @QueryParam(value="issuetypeNames") List<String> issuetypeNames, @Context UriInfo uriInfo) {
        if (this.featureManager.getDarkFeatures().isFeatureEnabled(DARK_FEATURE_DISABLE_CREATE_META)) {
            return Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)"This endpoint is disabled by the administrator. Please refer to https://confluence.atlassian.com/adminjira/createmeta-rest-endpoint-to-be-removed-975014604.html").build();
        }
        CreateMetaBean bean = this.beanBuilderFactory.newCreateMetaBeanBuilder().projectIds(projectIds).projectKeys(projectKeys).issueTypeIds(issuetypeIds).issueTypeNames(issuetypeNames).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes")
    @ResponseType(value=Page.class, genericTypes={CreateMetaIssueTypeBean.class})
    public Response getCreateIssueMetaProjectIssueTypes(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<CreateMetaIssueTypeBean> issueTypesForProject = this.beanBuilderFactory.newCreateMetaIssueTypeBeanBuilder(projectIdOrKey).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, issueTypesForProject).build(java.util.function.Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes/{issueTypeId}")
    @ResponseType(value=Page.class, genericTypes={FieldMetaBean.class})
    public Response getCreateIssueMetaFields(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="issueTypeId") String issueTypeId, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<FieldMetaBean> fieldMetaBeanPage = this.beanBuilderFactory.newCreateMetaFieldBeanBuilder(projectIdOrKey, issueTypeId).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, fieldMetaBeanPage).build(java.util.function.Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="{issueIdOrKey}/editmeta")
    @ResponseType(value=EditMetaBean.class)
    public Response getEditIssueMeta(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        EditMetaBean bean = this.beanBuilderFactory.newEditMetaBeanBuilder().issue((Issue)issue).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}")
    @ResponseType(value=Void.class)
    public Response editIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers, IssueUpdateBean updateRequest) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.updateIssueResource.editIssue((Issue)issue, updateRequest, notifyUsers);
    }

    @PUT
    @Path(value="{issueIdOrKey}/assignee")
    @ResponseType(value=Void.class)
    public Response assign(@PathParam(value="issueIdOrKey") String issueIdOrKey, UserBean assigneeBean) {
        String assigneeName = assigneeBean == null ? null : assigneeBean.getName();
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.assignIssueResource.assignIssue((Issue)issue, assigneeName);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink")
    @ResponseType(value=List.class, genericTypes={RemoteIssueLinkBean.class})
    public Response getRemoteIssueLinks(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinks((Issue)issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    @ResponseType(value=RemoteIssueLinkBean.class)
    public Response getRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinkById((Issue)issue, linkId);
    }

    @POST
    @Path(value="{issueIdOrKey}/remotelink")
    @RequestType(value=RemoteIssueLinkCreateOrUpdateRequest.class)
    @ResponseType(value=RemoteIssueLinkCreateOrUpdateResponse.class)
    public Response createOrUpdateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.createOrUpdateRemoteIssueLink((Issue)issue, request, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    @ResponseType(value=Void.class)
    public Response updateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId, RemoteIssueLinkCreateOrUpdateRequest updateRequest) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.updateRemoteIssueLink((Issue)issue, linkId, updateRequest);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response deleteRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String remoteIssueLinkId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkById((Issue)issue, remoteIssueLinkId);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink")
    public Response deleteRemoteIssueLinkByGlobalId(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkByGlobalId((Issue)issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog")
    @ResponseType(value=WorklogWithPaginationBean.class)
    public Response getIssueWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.issueWorklogResource.getIssueWorklogs((Issue)issue);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog/{id}")
    @ResponseType(value=WorklogJsonBean.class)
    public Response getWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.issueWorklogResource.getWorklogForIssue(worklogId, (Issue)issue);
    }

    @PUT
    @Path(value="{issueIdOrKey}/worklog/{id}")
    @RequestType(value=WorklogJsonBean.class)
    @ResponseType(value=WorklogJsonBean.class)
    public Response updateWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, WorklogJsonBean request) {
        if (request.getId() != null && !request.getId().equals(worklogId)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.worklog.error.id.mismatch"));
        }
        request.setId(worklogId);
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.issueWorklogResource.updateWorklog((Issue)issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, null), this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response deleteWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="increaseBy") String increaseBy) {
        WorklogJsonBean request = new WorklogJsonBean();
        request.setId(worklogId);
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.issueWorklogResource.deleteWorklog((Issue)issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, increaseBy), this.contextUriInfo);
    }

    @POST
    @ResponseType(value=WorklogJsonBean.class)
    @Path(value="{issueIdOrKey}/worklog")
    public Response addWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="reduceBy") String reduceBy, WorklogJsonBean request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.issueWorklogResource.addWorklog((Issue)issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, reduceBy, null), this.contextUriInfo);
    }

    @GET
    @ResponseType(value=CommentsWithPaginationJsonBean.class)
    @Path(value="{issueIdOrKey}/comment")
    public Response getComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="expand") String expand) {
        Either maybeOrderByOrError = orderBy != null ? this.orderByRequestParser.parse(orderBy, CommentResource.CommentField.class).map(Option::some) : Either.right((Object)Option.none());
        return (Response)maybeOrderByOrError.leftMap(this.responseFactory::errorResponse).left().on(maybeOrderBy -> this.commentResource.getComments(issueIdOrKey, expand, PageRequests.request((Long)startAt, (Integer)maxResults), (Option<OrderByRequest<CommentResource.CommentField>>)maybeOrderBy));
    }

    @GET
    @ResponseType(value=CommentsWithPaginationJsonBean.class)
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response getComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand) {
        return this.commentResource.getComment(issueIdOrKey, commentId, expand);
    }

    @PUT
    @RequestType(value=CommentJsonBean.class)
    @ResponseType(value=CommentJsonBean.class)
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response updateComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.updateComment(issueIdOrKey, commentId, expand, request);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response deleteComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId) {
        return this.commentResource.deleteComment(issueIdOrKey, commentId);
    }

    @POST
    @RequestType(value=CommentJsonBean.class)
    @ResponseType(value=CommentJsonBean.class)
    @Path(value="{issueIdOrKey}/comment")
    public Response addComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.addComment(issueIdOrKey, expand, request);
    }

    @POST
    @RequestType(value=NotificationJsonBean.class)
    @Path(value="{issueIdOrKey}/notify")
    @ResponseType(value=Void.class)
    public Response notify(@PathParam(value="issueIdOrKey") String issueIdOrKey, NotificationJsonBean request) {
        AdhocNotificationService.ValidateNotificationResult result;
        if (MailFactory.getSettings().isSendingDisabled()) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.outgoing.mail.disabled")));
        }
        if (MailFactory.getServerManager().getDefaultSMTPMailServer() == null) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.no.smtp.defined")));
        }
        ApplicationUser user = this.authContext.getUser();
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        ErrorCollection errors = ErrorCollection.of(new String[0]);
        ServiceOutcome notificationBuilder = AdhocNotificationServiceImpl.makeBuilder((NotificationBuilder)this.notificationService.makeBuilder(), (NotificationJsonBean)request, (I18nHelper)this.i18n);
        if (!notificationBuilder.isValid()) {
            errors.addErrorCollection(notificationBuilder.getErrorCollection());
        }
        if (!(result = this.notificationService.validateNotification((NotificationBuilder)notificationBuilder.getReturnedValue(), user, (Issue)issue)).isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, errors.addErrorCollection(result.getErrorCollection()));
        }
        this.notificationService.sendNotification(result);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected Response BAD_REQUEST() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    protected static Response NO_CONTENT() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    public Collection<FieldMetaBean> getRequiredFields(FieldScreenRenderer fieldScreenRenderer, Issue issue) {
        ArrayList<FieldMetaBean> fields = new ArrayList<FieldMetaBean>();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (Object fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                OrderableField orderableField;
                if (!fieldScreenRenderLayoutItem.isShow(issue) || !"resolution".equals((orderableField = fieldScreenRenderLayoutItem.getOrderableField()).getId())) continue;
                fieldScreenRenderLayoutItem = new FieldScreenRenderLayoutItemImpl(fieldScreenRenderLayoutItem.getFieldScreenLayoutItem(), fieldScreenRenderLayoutItem.getFieldLayoutItem()){

                    public boolean isRequired() {
                        return true;
                    }
                };
            }
        }
        return fields;
    }
}

