/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.serializer.DefaultValueSerializer;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="availableField")
public class FieldMetaBean {
    @XmlElement
    private boolean required;
    @XmlElement
    private JsonTypeBean schema;
    @XmlElement
    private String name;
    @XmlElement
    private String fieldId;
    @XmlElement
    private String autoCompleteUrl;
    @XmlElement
    private Boolean hasDefaultValue;
    @XmlElement
    private Collection<String> operations;
    @XmlElement
    private Collection<?> allowedValues;
    @XmlElement
    @JsonSerialize(using=DefaultValueSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    private Object defaultValue;
    public static final FieldMetaBean DOC_EXAMPLE = new FieldMetaBean(false, false, JsonTypeBuilder.customArray((String)"option", (String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (Long)10001L), "My Multi Select", "customfield_10000", null, Lists.newArrayList((Object[])new String[]{StandardOperation.SET.getName(), StandardOperation.ADD.getName()}), Lists.newArrayList((Object[])new String[]{"red", "blue", "default value"}), null);

    FieldMetaBean() {
    }

    public FieldMetaBean(boolean required, Boolean hasDefaultValue, JsonType schema, String name, String fieldId, String autoCompleteUrl, Collection<String> operations, Collection<?> allowedValues, Object defaultValue) {
        this.required = required;
        this.hasDefaultValue = hasDefaultValue;
        this.schema = schema == null ? null : new JsonTypeBean(schema);
        this.name = name;
        this.fieldId = fieldId;
        this.autoCompleteUrl = autoCompleteUrl;
        this.operations = operations;
        this.allowedValues = allowedValues;
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public JsonTypeBean getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getAutoCompleteUrl() {
        return this.autoCompleteUrl;
    }

    public Boolean getHasDefaultValue() {
        return this.hasDefaultValue;
    }

    public Collection<String> getOperations() {
        return this.operations;
    }

    public Collection<?> getAllowedValues() {
        return this.allowedValues;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

