/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.Dates;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFieldMetaBeanHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultFieldMetaBeanHelper.class);
    protected Project project;
    private IssueType issueType;
    private IssueSecurityLevelManager issueSecurityLevelManager;

    public DefaultFieldMetaBeanHelper(Project project, IssueType issueType, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.project = project;
        this.issueType = issueType;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    public boolean hasDefaultValue(OrderableField field) {
        if (field instanceof CustomField) {
            FieldConfig relevantConfig = ((CustomField)field).getRelevantConfig((IssueContext)new IssueContextImpl(this.project, this.issueType));
            Object defaultValue = ((CustomField)field).getCustomFieldType().getDefaultValue(relevantConfig);
            if (defaultValue instanceof String) {
                return StringUtils.isNotBlank((CharSequence)((String)defaultValue));
            }
            if (defaultValue instanceof Collection) {
                return CollectionUtils.isNotEmpty((Collection)((Collection)defaultValue));
            }
            if (defaultValue instanceof Map) {
                return MapUtils.isNotEmpty((Map)((Map)defaultValue)) && MapUtils.getObject((Map)((Map)defaultValue), null) != null;
            }
            return defaultValue != null;
        }
        boolean hasDefaultValue = field instanceof PrioritySystemField ? ((PrioritySystemField)field).getDefaultValue((IssueContext)new IssueContextImpl(this.project, this.issueType)) != null : (field instanceof AssigneeSystemField ? this.project != null && this.project.getAssigneeType() != null && this.project.getAssigneeType() != 3L : (field instanceof SecurityLevelSystemField ? this.project != null && this.issueSecurityLevelManager.getDefaultSecurityLevel(this.project) != null : false));
        return hasDefaultValue;
    }

    @Nullable
    public Object getJsonDefaultValue(FieldTypeInfoContext context) {
        try {
            OrderableField field = context.getOderableField();
            if (field instanceof RestFieldOperations) {
                RestFieldOperations restField = (RestFieldOperations)field;
                IssueContext issueContext = context.getIssueContext();
                JsonData defaultJsonValue = restField.getJsonDefaultValue(issueContext);
                if (defaultJsonValue == null || defaultJsonValue.isNull()) {
                    return null;
                }
                if (this.isDateCFType(restField)) {
                    Date date = (Date)defaultJsonValue.getData();
                    return Dates.asDateString((Date)date);
                }
                return defaultJsonValue.getData();
            }
        }
        catch (Exception e) {
            log.warn("Cannot get default value.", (Throwable)e);
        }
        return null;
    }

    private boolean isDateCFType(RestFieldOperations field) {
        return field instanceof CustomField && ((CustomField)field).getCustomFieldType() instanceof DateCFType;
    }
}

