/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.v2.issue.CreateMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CreateMetaIssueTypeBeanBuilder {
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ContextUriInfo contextUriInfo;
    private final JiraBaseUrls baseUrls;
    private final BeanBuilderFactory beanBuilderFactory;
    private Project project;
    private Predicate<IssueType> issueTypePredicate = x -> true;
    private boolean expandFields = false;

    public CreateMetaIssueTypeBeanBuilder(ProjectManager projectManager, ContextUriInfo contextUriInfo, IssueTypeSchemeManager issueTypeSchemeManager, JiraBaseUrls baseUrls, String projectIdOrKey, BeanBuilderFactory beanBuilderFactory) {
        this.projectManager = projectManager;
        this.contextUriInfo = contextUriInfo;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.baseUrls = baseUrls;
        this.beanBuilderFactory = beanBuilderFactory;
        this.projectIdOrKey(projectIdOrKey);
    }

    public CreateMetaIssueTypeBeanBuilder projectIdOrKey(String projectIdOrKey) {
        Preconditions.checkArgument((projectIdOrKey != null ? 1 : 0) != 0);
        Project project = this.getProject(projectIdOrKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project with id/key: %s doesn't exist", (Object)projectIdOrKey);
        this.project = project;
        return this;
    }

    public CreateMetaIssueTypeBeanBuilder issueType(Predicate<IssueType> issueTypePredicate) {
        this.issueTypePredicate = (Predicate)Preconditions.checkNotNull(issueTypePredicate);
        return this;
    }

    public CreateMetaIssueTypeBeanBuilder expandFields(boolean expandFields) {
        this.expandFields = expandFields;
        return this;
    }

    public List<CreateMetaIssueTypeBean> build() {
        return this.issueTypeSchemeManager.getIssueTypesForProject(this.project).stream().filter(this.issueTypePredicate).map(this::createIssueTypeBean).collect(Collectors.toList());
    }

    public Page<CreateMetaIssueTypeBean> buildPaged(PageRequest pageRequest) {
        List<CreateMetaIssueTypeBean> allIssueTypesForProject = this.build();
        allIssueTypesForProject.sort(Comparator.comparing(IssueTypeJsonBean::getId));
        return Pages.toPage(allIssueTypesForProject, (PageRequest)pageRequest);
    }

    private CreateMetaIssueTypeBean createIssueTypeBean(IssueType issueType) {
        IssueTypeJsonBean issueTypeBean = new IssueTypeBeanBuilder().jiraBaseUrls(this.baseUrls).context(this.contextUriInfo).issueType(issueType).build();
        CreateMetaFieldBeanBuilder fieldsBuilder = null;
        if (this.expandFields) {
            fieldsBuilder = this.beanBuilderFactory.newCreateMetaFieldBeanBuilder(this.project.getKey(), issueType.getId());
        }
        return new CreateMetaIssueTypeBean(issueTypeBean.getSelf(), issueTypeBean.getId(), issueTypeBean.getName(), issueTypeBean.getDescription(), issueTypeBean.isSubtask(), issueTypeBean.getIconUrl(), fieldsBuilder);
    }

    private Project getProject(String projectIdOrKey) {
        return (Project)ProjectKeyOrId.parse(projectIdOrKey).fold(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0), arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0));
    }
}

