/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateIssueOperationContext;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;

public class CreateMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private static final String PARENT_FIELD_ID = "parent";
    private final OperationContext operationContext = new CreateIssueOperationContext();
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;

    public CreateMetaFieldBeanBuilder(FieldLayoutManager fieldLayoutManager, Project project, IssueType issueType, IssueFactory issueFactory, ApplicationUser user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, JiraBaseUrls baseUrls, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, JiraAuthenticationContext authContext, FieldManager fieldManager, DefaultFieldMetaBeanHelper defaultFieldHelper) {
        super(fieldLayoutManager, project, CreateMetaFieldBeanBuilder.getIssue(issueFactory, project, issueType), issueType, user, versionBeanFactory, velocityRequestContextFactory, baseUrls, defaultFieldHelper);
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
    }

    private static Issue getIssue(IssueFactory issueFactory, Project project, IssueType issueType) {
        MutableIssue nullIssue = issueFactory.getIssue();
        nullIssue.setProjectObject(project);
        nullIssue.setIssueTypeObject(issueType);
        return nullIssue;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    protected void addAdditionalFields(Map<String, FieldMetaBean> fields) {
        fields.put("project", this.createProjectFieldMetaBean());
        if (!fields.containsKey("issuetype")) {
            fields.put("issuetype", this.createIssueTypeFieldMetaBean());
        }
        if (this.issueType.isSubTask()) {
            fields.put(PARENT_FIELD_ID, this.createParentFieldMetaBean());
        }
    }

    @Override
    protected Stream<String> getAdditionalKeys() {
        Stream<String> mainIds = Stream.of("project", "issuetype");
        if (this.issueType.isSubTask()) {
            return Stream.concat(mainIds, Stream.of(PARENT_FIELD_ID));
        }
        return mainIds;
    }

    private FieldMetaBean createParentFieldMetaBean() {
        return new FieldMetaBean(true, false, JsonTypeBuilder.system((String)"issuelink", (String)PARENT_FIELD_ID), this.authContext.getI18nHelper().getText("issue.field.parent"), PARENT_FIELD_ID, null, Collections.singletonList(StandardOperation.SET.getName()), null, null);
    }

    private FieldMetaBean createIssueTypeFieldMetaBean() {
        return this.getFieldMetaBean(true, this.fieldManager.getOrderableField("issuetype"));
    }

    private FieldMetaBean createProjectFieldMetaBean() {
        return new FieldMetaBean(true, false, ProjectSystemField.getJsonType(), this.authContext.getI18nHelper().getText("issue.field.project"), "project", null, Collections.singletonList(StandardOperation.SET.getName()), Collections.singletonList(ProjectJsonBean.shortBean((Project)this.project, (JiraBaseUrls)this.baseUrls)), null);
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return this.permissionManager.hasPermission(11, this.issue, this.user);
    }

    @Override
    Stream<FieldScreenRenderTab> getFieldScreenRenderTabsStream(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION).getFieldScreenRenderTabs().stream();
    }

    public Page<FieldMetaBean> buildPaged(PageRequest pageRequest) {
        ArrayList<FieldMetaBean> allFieldMetaForIssueTypeInProject = new ArrayList<FieldMetaBean>(this.build().values());
        allFieldMetaForIssueTypeInProject.sort(Comparator.comparing(FieldMetaBean::getFieldId));
        return Pages.toPage(allFieldMetaForIssueTypeInProject, (PageRequest)pageRequest);
    }
}

