/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.CreateMetaBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateMetaProjectBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@Deprecated
public class CreateMetaBeanBuilder {
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionManager permissionManager;
    private final JiraBaseUrls baseUrls;
    private final BeanBuilderFactory beanBuilderFactory;
    private List<StringList> projectIds;
    private List<StringList> projectKeys;
    private List<StringList> issueTypeIds;
    private List<String> issueTypeNames;

    public CreateMetaBeanBuilder(JiraAuthenticationContext authContext, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager, PermissionManager permissionManager, JiraBaseUrls baseUrls, BeanBuilderFactory beanBuilderFactory) {
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionManager = permissionManager;
        this.baseUrls = baseUrls;
        this.beanBuilderFactory = beanBuilderFactory;
    }

    private static <T> List<T> mapNullToEmptyList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public CreateMetaBeanBuilder projectIds(List<StringList> projectIds) {
        this.projectIds = CreateMetaBeanBuilder.mapNullToEmptyList(projectIds);
        return this;
    }

    public CreateMetaBeanBuilder projectKeys(List<StringList> projectKeys) {
        this.projectKeys = CreateMetaBeanBuilder.mapNullToEmptyList(projectKeys);
        return this;
    }

    public CreateMetaBeanBuilder issueTypeIds(List<StringList> issueTypeIds) {
        this.issueTypeIds = CreateMetaBeanBuilder.mapNullToEmptyList(issueTypeIds);
        return this;
    }

    public CreateMetaBeanBuilder issueTypeNames(List<String> issueTypeNames) {
        this.issueTypeNames = CreateMetaBeanBuilder.mapNullToEmptyList(issueTypeNames);
        return this;
    }

    public CreateMetaBean build() {
        Collection<Project> projects = this.getProjects(this.projectIds, this.projectKeys);
        Predicate<IssueType> issueTypes = this.makeIssueTypesPredicate(this.issueTypeIds, this.issueTypeNames);
        ArrayList<CreateMetaProjectBean> projectBeans = new ArrayList<CreateMetaProjectBean>(projects.size());
        for (Project project : projects) {
            CreateMetaIssueTypeBeanBuilder issueTypeBeanBuilder = this.beanBuilderFactory.newCreateMetaIssueTypeBeanBuilder(project.getKey());
            projectBeans.add(this.createProjectBean(project, issueTypeBeanBuilder, issueTypes));
        }
        return new CreateMetaBean(projectBeans);
    }

    private CreateMetaProjectBean createProjectBean(Project project, CreateMetaIssueTypeBeanBuilder issueTypeBeanBuilder, Predicate<IssueType> includeIssueType) {
        List<CreateMetaIssueTypeBean> issueTypeBeans = issueTypeBeanBuilder.projectIdOrKey(project.getKey()).issueType(includeIssueType).expandFields(true).build();
        ProjectJsonBean projectBean = ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.baseUrls);
        return new CreateMetaProjectBean(projectBean.getSelf(), projectBean.getId(), projectBean.getKey(), projectBean.getName(), projectBean.getAvatarUrls(), issueTypeBeans);
    }

    private List<IssueType> getIssueTypesForProject(Project project, Predicate<IssueType> includeIssueType) {
        Collection allIssueTypesForProject = this.issueTypeSchemeManager.getIssueTypesForProject(project);
        ArrayList<IssueType> result = new ArrayList<IssueType>(allIssueTypesForProject.size());
        for (IssueType issueType : allIssueTypesForProject) {
            if (!includeIssueType.test(issueType)) continue;
            result.add(issueType);
        }
        return result;
    }

    private Collection<Project> getProjects(List<StringList> projectIds, List<StringList> projectKeys) {
        if (projectIds.isEmpty() && projectKeys.isEmpty()) {
            return this.getAllProjects();
        }
        LinkedHashMap<Long, Project> projects = new LinkedHashMap<Long, Project>();
        this.addProjectsById((List<String>)StringList.joinLists(projectIds).asList(), (Map<Long, Project>)projects);
        this.addProjectsByKey((List<String>)StringList.joinLists(projectKeys).asList(), (Map<Long, Project>)projects);
        return projects.values();
    }

    private boolean hasCreatePerm(Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, this.authContext.getUser());
    }

    private List<Project> getAllProjects() {
        return new ArrayList<Project>(this.permissionManager.getProjects(ProjectPermissions.CREATE_ISSUES, this.authContext.getUser()));
    }

    private void addProjectsById(List<String> projectIds, Map<Long, Project> projects) {
        for (String projectId : projectIds) {
            long projectIdLong;
            try {
                projectIdLong = Long.parseLong(projectId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            Project project = this.projectManager.getProjectObj(Long.valueOf(projectIdLong));
            if (project == null || !this.hasCreatePerm(project) || projects.containsKey(project.getId())) continue;
            projects.put(project.getId(), project);
        }
    }

    private void addProjectsByKey(List<String> projectKeys, Map<Long, Project> projects) {
        for (String projectKey : projectKeys) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null || !this.hasCreatePerm(project) || projects.containsKey(project.getId())) continue;
            projects.put(project.getId(), project);
        }
    }

    private Predicate<IssueType> makeIssueTypesPredicate(List<StringList> issueTypeIdsList, List<String> issueTypeNames) {
        HashSet<String> issueTypeIds = new HashSet<String>((Collection<String>)StringList.joinLists(issueTypeIdsList).asList());
        HashSet<String> issueTypeNameSet = new HashSet<String>(issueTypeNames);
        return input -> issueTypeIds.isEmpty() && issueTypeNameSet.isEmpty() || issueTypeIds.contains(input.getId()) || issueTypeNameSet.contains(input.getName());
    }
}

