/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.event.bc.project.component.ProjectComponentCreatedViaRestEvent;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.component.ComponentIssueCountsBean;
import com.atlassian.jira.rest.v2.issue.component.ComponentIssueCountsBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="component")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ComponentResource {
    private static final String COMPONENT_LEAD = "componentLead";
    private static final String LEAD_USER_NAME = "leadUserName";
    private ProjectComponentService projectComponentService;
    private ProjectComponentManager projectComponentManager;
    private ProjectService projectService;
    private UserManager userManager;
    private AvatarService avatarService;
    private JiraAuthenticationContext authContext;
    private I18nHelper i18n;
    private PermissionManager permissionManager;
    private ProjectManager projectManager;
    private ComponentIssueCountsBeanFactory componentIssueCountsBeanFactory;
    private JiraBaseUrls jiraBaseUrls;
    private EventPublisher eventPublisher;

    private ComponentResource() {
    }

    public ComponentResource(ProjectComponentService projectComponentService, ProjectComponentManager projectComponentManager, ProjectService projectService, UserManager userManager, AvatarService avatarService, ComponentIssueCountsBeanFactory componentIssueCountsBeanFactory, JiraAuthenticationContext authContext, I18nHelper i18n, PermissionManager permissionManager, ProjectManager projectManager, JiraBaseUrls jiraBaseUrls, EventPublisher eventPublisher) {
        this.projectComponentService = projectComponentService;
        this.projectComponentManager = projectComponentManager;
        this.projectService = projectService;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.componentIssueCountsBeanFactory = componentIssueCountsBeanFactory;
        this.authContext = authContext;
        this.i18n = i18n;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Path(value="{id}")
    @ResponseType(value=ComponentBean.class)
    public Response getComponent(@PathParam(value="id") String id) {
        try {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            ProjectComponent component = this.projectComponentService.find(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection, Long.valueOf(Long.parseLong(id)));
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            Project project = this.getProject(component);
            ComponentBean componentBean = this.getComponentBean(component, project);
            return Response.ok((Object)componentBean).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nosuchcomponent.withid", id)));
        }
    }

    private ComponentBean getComponentBean(ProjectComponent component, Project project) {
        return ComponentBean.fullComponent(component, project, this.jiraBaseUrls, this.userManager, this.avatarService, this.permissionManager, this.projectManager);
    }

    @POST
    @ResponseType(value=ComponentBean.class)
    @RequestType(value=ComponentBean.class)
    public Response createComponent(ComponentBean bean) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)bean.getProject())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nullprojectid")));
        }
        if (StringUtils.isEmpty((CharSequence)bean.getName())) {
            errorCollection.addError("name", this.i18n.getText("admin.projects.component.namenotset"));
            throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
        ApplicationUser user = this.authContext.getUser();
        ProjectService.GetProjectResult getResult = this.projectService.getProjectByKeyForAction(user, bean.getProject(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (!getResult.isValid()) {
            this.throwWebException(getResult.getErrorCollection());
        }
        Project project = getResult.getProject();
        String leadUserName = bean.getLead() != null ? bean.getLead().getName() : bean.getLeadUserName();
        String leadUserKey = null;
        if (leadUserName != null && leadUserName.length() > 0) {
            ApplicationUser leadUser = this.userManager.getUserByName(leadUserName);
            if (leadUser == null) {
                errorCollection.addError(COMPONENT_LEAD, this.i18n.getText("admin.projects.component.userdoesnotexist", leadUserName));
            } else {
                leadUserKey = leadUser.getKey();
            }
        }
        Long assigneeType = bean.getAssigneeType() == null ? null : Long.valueOf(bean.getAssigneeType().getId());
        ProjectComponent newComponent = this.projectComponentService.create(user, (com.atlassian.jira.util.ErrorCollection)errorCollection, bean.getName(), bean.getDescription(), leadUserKey, project.getId(), assigneeType);
        if (errorCollection.hasAnyErrors()) {
            this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
        }
        this.eventPublisher.publish((Object)new ProjectComponentCreatedViaRestEvent(newComponent));
        ComponentBean componentBean = this.getComponentBean(newComponent, project);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)componentBean).location(componentBean.getSelf()).cacheControl(CacheControl.never()).build();
    }

    private Project getProject(ProjectComponent component) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(this.authContext.getUser(), component.getProjectId());
        if (!projectResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(projectResult.getErrorCollection()));
        }
        return projectResult.getProject();
    }

    private Project getProjectForAdmin(ProjectComponent component) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByIdForAction(this.authContext.getUser(), component.getProjectId(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (!projectResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(projectResult.getErrorCollection()));
        }
        return projectResult.getProject();
    }

    @PUT
    @Path(value="{id}")
    @ResponseType(value=ComponentBean.class)
    public Response updateComponent(@PathParam(value="id") String id, ComponentBean bean) {
        try {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            ProjectComponent currentComponent = this.projectComponentService.find(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection, Long.valueOf(Long.parseLong(id)));
            if (!errorCollection.hasAnyErrors()) {
                MutableProjectComponent mutableComponent = MutableProjectComponent.copy((ProjectComponent)currentComponent);
                this.update(bean, mutableComponent, errorCollection);
                ProjectComponent projectComponent = this.projectComponentService.update(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection, mutableComponent);
                if (errorCollection.hasAnyErrors()) {
                    this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
                }
                ComponentBean componentBean = this.getComponentBean(projectComponent, this.getProjectForAdmin(projectComponent));
                return Response.ok((Object)componentBean).cacheControl(CacheControl.never()).build();
            }
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nosuchcomponent.withid", id)));
        }
    }

    private void update(ComponentBean bean, MutableProjectComponent currentComponent, SimpleErrorCollection errorCollection) {
        if (bean.getDescription() != null) {
            currentComponent.setDescription(bean.getDescription());
        }
        if (bean.getName() != null) {
            currentComponent.setName(bean.getName());
        }
        if (bean.getLead() != null) {
            currentComponent.setLead(bean.getLead().getKey());
        } else {
            String leadUserName = bean.getLeadUserName();
            if (leadUserName != null) {
                if (StringUtils.isEmpty((CharSequence)leadUserName)) {
                    currentComponent.setLead(null);
                } else {
                    ApplicationUser leadUser = this.userManager.getUserByName(leadUserName);
                    if (leadUser == null) {
                        errorCollection.addError(COMPONENT_LEAD, this.i18n.getText("admin.projects.component.userdoesnotexist", leadUserName));
                        return;
                    }
                    currentComponent.setLead(leadUser.getKey());
                }
            }
        }
        if (bean.getAssigneeType() != null) {
            currentComponent.setAssigneeType(bean.getAssigneeType().getId());
        }
        if (bean.isArchived() != null) {
            currentComponent.setArchived(bean.isArchived().booleanValue());
        }
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        if (errorCollection.getErrors().containsKey(COMPONENT_LEAD)) {
            errorCollection.getErrors().put(LEAD_USER_NAME, errorCollection.getErrors().get(COMPONENT_LEAD));
        }
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    @AnonymousAllowed
    @GET
    @ResponseType(value=ComponentIssueCountsBean.class)
    @Path(value="{id}/relatedIssueCounts")
    public Response getComponentRelatedIssues(@PathParam(value="id") String id) {
        try {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            ProjectComponent component = this.projectComponentService.find(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection, Long.valueOf(Long.parseLong(id)));
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            Collection issues = this.projectComponentManager.getIssueIdsWithComponent(component);
            return Response.ok((Object)this.componentIssueCountsBeanFactory.createComponentBean(component, issues.size())).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nosuchcomponent.withid", id)));
        }
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id, @QueryParam(value="moveIssuesTo") String moveIssuesTo) {
        long componentId = -1L;
        try {
            componentId = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nosuchcomponent.withid", (Object)componentId)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectComponent component = this.projectComponentService.find(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection, Long.valueOf(componentId));
        if (errorCollection.hasAnyErrors()) {
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getUser());
        if (moveIssuesTo != null) {
            this.projectComponentService.deleteAndSwapComponentForIssues((JiraServiceContext)serviceContext, Long.valueOf(componentId), Long.valueOf(this.getComponentIdFromSelfLink(moveIssuesTo)));
        } else {
            this.projectComponentService.deleteComponentForIssues((JiraServiceContext)serviceContext, Long.valueOf(componentId));
        }
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            this.throwWebException(serviceContext.getErrorCollection());
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private long getComponentIdFromSelfLink(String path) {
        String componentIdString = path.substring(path.lastIndexOf(47) + 1);
        long afterComponentId = -1L;
        try {
            afterComponentId = Long.parseLong(componentIdString);
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.projects.component.nosuchcomponent.withid", (Object)afterComponentId)));
        }
        return afterComponentId;
    }
}

