/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="avatar")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvatarResource {
    private final AvatarResourceHelper avatarResourceHelper;

    public AvatarResource(JiraAuthenticationContext authContext, AvatarManager avatarManager, AvatarService avatarService, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper, UserManager userManager) {
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarService, avatarPickerHelper, attachmentHelper, userManager);
    }

    @GET
    @Path(value="{type}/system")
    @ResponseType(value=AvatarBean.SystemAvatars.class)
    public Response getAllSystemAvatars(@PathParam(value="type") String type) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.getAllSystemAvatars(iconType);
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{type}/temporary")
    @ResponseType(value=AvatarCroppingBean.class)
    public Response storeTemporaryAvatar(@PathParam(value="type") String type, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.storeTemporaryAvatar(iconType, null, filename, size, request);
    }

    @POST
    @Path(value="{type}/temporaryCrop")
    @ResponseType(value=Void.class)
    public Response createAvatarFromTemporary(@PathParam(value="type") String type, AvatarCroppingBean croppingInstructions) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.cropTemporaryAvatar(iconType, null, croppingInstructions);
    }
}

