/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.archiving.ArchivedIssueService;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveIssueResource {
    private static final Logger log = LoggerFactory.getLogger(ArchiveIssueResource.class);
    private final JiraAuthenticationContext authContext;
    private final ArchivedIssueService archivedIssueService;
    private final ResponseFactory responses;

    public ArchiveIssueResource(JiraAuthenticationContext authContext, @ComponentImport ArchivedIssueService archivedIssueService, ResponseFactory responses) {
        this.authContext = authContext;
        this.archivedIssueService = archivedIssueService;
        this.responses = responses;
    }

    public Response archiveIssue(String issueKey, boolean notifyUsers) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        ArchivedIssueService.ValidationResult validationResult = this.archivedIssueService.validateArchiveIssue(this.authContext.getLoggedInUser(), issueKey, notifyUsers);
        if (!validationResult.isValid()) {
            log.error(validationResult.toString());
            return this.responses.errorResponse(validationResult.getErrorCollection());
        }
        ArchivedIssueService.ArchivingResult result = this.archivedIssueService.archiveIssue(validationResult);
        if (result.isValid()) {
            return this.responses.noContent();
        }
        log.error(result.toString());
        return this.responses.errorResponse(result.getErrorCollection());
    }

    public Response restoreIssue(String issueKey, boolean notifyUsers) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        ArchivedIssueService.ValidationResult validationResult = this.archivedIssueService.validateRestoreIssue(this.authContext.getLoggedInUser(), issueKey, notifyUsers);
        if (!validationResult.isValid()) {
            log.error(validationResult.toString());
            return this.responses.errorResponse(validationResult.getErrorCollection());
        }
        ArchivedIssueService.ArchivingResult result = this.archivedIssueService.restoreIssue(validationResult);
        if (result.isValid()) {
            return this.responses.noContent();
        }
        log.error(result.toString());
        return this.responses.errorResponse(result.getErrorCollection());
    }
}

