/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index.summary;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.index.summary.IndexSummarizer;
import com.atlassian.jira.index.summary.IssueIndexSummary;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.index.summary.IndexSummaryBean;
import com.atlassian.jira.rest.v2.index.summary.IndexSummaryBeanBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rest.annotation.ResponseType;
import java.time.Instant;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="index/summary")
public class IndexSummaryResource {
    private final ResponseFactory responseFactory;
    private final ClusterManager clusterManager;
    private final IndexSummarizer indexSummarizer;

    public IndexSummaryResource(ResponseFactory responseFactory, @ComponentImport ClusterManager clusterManager, @ComponentImport IndexSummarizer indexSummarizer) {
        this.responseFactory = responseFactory;
        this.clusterManager = clusterManager;
        this.indexSummarizer = indexSummarizer;
    }

    @GET
    @ResponseType(value=IndexSummaryBean.class)
    @ExperimentalApi
    public Response getIndexSummary() {
        IndexSummaryBeanBuilder beanBuilder = new IndexSummaryBeanBuilder();
        ServiceOutcome issueIndexSummaryOutcome = this.indexSummarizer.summarizeIssueIndex();
        if (!issueIndexSummaryOutcome.isValid()) {
            return this.responseFactory.errorResponse(issueIndexSummaryOutcome.getErrorCollection());
        }
        beanBuilder.issueIndex((IssueIndexSummary)issueIndexSummaryOutcome.get());
        if (this.clusterManager.isClustered()) {
            ServiceOutcome queueSummaryOutcome = this.indexSummarizer.summarizeIndexReplicationQueues();
            if (!queueSummaryOutcome.isValid()) {
                return this.responseFactory.errorResponse(queueSummaryOutcome.getErrorCollection());
            }
            ((Map)queueSummaryOutcome.get()).forEach(beanBuilder::queue);
            beanBuilder.nodeId(this.clusterManager.getNodeId());
        }
        beanBuilder.reportTime(Instant.now());
        return Response.ok((Object)beanBuilder.build()).build();
    }
}

