/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.cluster.zdu;

import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.feature.RequiresDarkFeature;
import com.atlassian.rest.annotation.ResponseType;
import java.net.URI;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="cluster/zdu")
@RequiresDarkFeature(value={"jira.zdu.cluster-upgrade-state"})
public class ClusterUpgradeStateResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager permissionManager;
    private final ClusterUpgradeStateManager clusterUpgradeStateManager;

    public ClusterUpgradeStateResource(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport GlobalPermissionManager permissionManager, @ComponentImport ClusterUpgradeStateManager clusterUpgradeStateManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.clusterUpgradeStateManager = clusterUpgradeStateManager;
    }

    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    @ResponseType(value=ClusterState.class)
    public Response getState() {
        return this.onlyAsSystemAdmin(() -> Response.ok((Object)new ClusterState(this.clusterUpgradeStateManager.getUpgradeState(), this.clusterUpgradeStateManager.getClusterBuildInfo())).build());
    }

    @POST
    @Path(value="cancel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResponseType(value=Void.class)
    public Response cancelUpgrade(@Context UriInfo uri) {
        return this.onlyAsSystemAdmin(() -> {
            try {
                this.clusterUpgradeStateManager.cancelUpgrade();
            }
            catch (IllegalStateException e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
            }
            return Response.created((URI)uri.getRequestUri()).build();
        });
    }

    @POST
    @Path(value="start")
    @Consumes(value={"application/json"})
    @ResponseType(value=Void.class)
    public Response setReadyToUpgrade(@Context UriInfo uri) {
        return this.onlyAsSystemAdmin(() -> {
            try {
                this.clusterUpgradeStateManager.startUpgrade();
            }
            catch (IllegalStateException e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
            }
            return Response.created((URI)uri.getRequestUri()).build();
        });
    }

    @POST
    @Path(value="approve")
    @Consumes(value={"application/json"})
    @ResponseType(value=Void.class)
    public Response approveUpgrade() {
        return this.onlyAsSystemAdmin(() -> {
            try {
                this.clusterUpgradeStateManager.approveUpgrade();
            }
            catch (IllegalStateException e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
            }
            return Response.ok().build();
        });
    }

    @POST
    @Path(value="retryUpgrade")
    @Consumes(value={"application/json"})
    @ResponseType(value=Void.class)
    public Response acknowledgeErrors() {
        return this.onlyAsSystemAdmin(() -> {
            try {
                this.clusterUpgradeStateManager.retryUpgrade();
            }
            catch (IllegalStateException e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
            }
            return Response.ok().build();
        });
    }

    private Response onlyAsSystemAdmin(Supplier<Response> runOnlyAsAdmin) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            return runOnlyAsAdmin.get();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public static class ClusterState {
        private final UpgradeState state;
        private final NodeBuildInfo buildInfo;

        public ClusterState(UpgradeState state, NodeBuildInfo buildInfo) {
            this.state = state;
            this.buildInfo = buildInfo;
        }

        @JsonProperty(value="state")
        public UpgradeState getState() {
            return this.state;
        }

        @JsonProperty(value="build")
        public NodeBuildInfo getBuildInfo() {
            return this.buildInfo;
        }
    }
}

