/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.admin.workflowscheme.AssignableRestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DraftRestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.RestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.rest.annotation.ResponseTypes;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="workflowscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
public class WorkflowSchemeResource {
    private final AssignableRestWorkflowScheme.Factory factory;
    private final WorkflowManager workflowManager;
    private final IssueTypeManager issueTypeManager;
    private final JiraAuthenticationContext authenticationContext;

    public WorkflowSchemeResource(AssignableRestWorkflowScheme.Factory factory, WorkflowManager workflowManager, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext) {
        this.factory = factory;
        this.workflowManager = workflowManager;
        this.issueTypeManager = issueTypeManager;
        this.authenticationContext = authenticationContext;
    }

    @GET
    @Path(value="{id}")
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response getById(@PathParam(value="id") long id, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.draftMaybe(returnDraftIfExists, new Function<RestWorkflowScheme, Response>(){

            public Response apply(RestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asBean());
            }
        }));
    }

    @POST
    @RequestType(value=WorkflowSchemeBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response createScheme(WorkflowSchemeBean bean) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.create(bean);
        if (outcome.isValid()) {
            return WorkflowSchemeResource.responseCreated(((AssignableRestWorkflowScheme)outcome.getReturnedValue()).asBean());
        }
        return WorkflowSchemeResource.responseError(outcome);
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteScheme(@PathParam(value="id") long id) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        return WorkflowSchemeResource.response(((AssignableRestWorkflowScheme)outcome.getReturnedValue()).delete());
    }

    @PUT
    @Path(value="{id}")
    @RequestType(value=WorkflowSchemeBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response update(@PathParam(value="id") long id, final WorkflowSchemeBean bean) {
        return this.withScheme(id, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.update(bean);
            }
        }));
    }

    @GET
    @Path(value="{id}/draft")
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response getDraftById(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)new Function<DraftRestWorkflowScheme, Response>(){

            public Response apply(DraftRestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asBean());
            }
        });
    }

    @DELETE
    @Path(value="{id}/draft")
    public Response deleteDraftById(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)new Function<DraftRestWorkflowScheme, Response>(){

            public Response apply(DraftRestWorkflowScheme input) {
                return WorkflowSchemeResource.response(input.delete());
            }
        });
    }

    @POST
    @Path(value="{id}/createdraft")
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response createDraftForParent(@PathParam(value="id") long id) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        ServiceOutcome<DraftRestWorkflowScheme> draftOutcome = ((AssignableRestWorkflowScheme)outcome.getReturnedValue()).createDraftScheme();
        if (!draftOutcome.isValid()) {
            return WorkflowSchemeResource.responseError(draftOutcome);
        }
        return WorkflowSchemeResource.responseCreated(((DraftRestWorkflowScheme)draftOutcome.getReturnedValue()).asBean());
    }

    @PUT
    @RequestType(value=WorkflowSchemeBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    @Path(value="{id}/draft")
    public Response updateDraft(@PathParam(value="id") long id, final WorkflowSchemeBean bean) {
        return this.withScheme(id, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.updateDraft(bean);
            }
        }));
    }

    @GET
    @Path(value="{id}/workflow")
    @ResponseTypes(value={@ResponseType(status=200, value=WorkflowMappingBean.class), @ResponseType(status=200, value=List.class, genericTypes={WorkflowMappingBean.class})})
    public Response getWorkflow(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.checkWorkflow(workflowName, true, this.draftMaybe(returnDraftIfExists, new Function<RestWorkflowScheme, Response>(){

            public Response apply(RestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(workflowName == null ? input.asWorkflowBeans() : input.asWorkflowBean(workflowName));
            }
        })));
    }

    @GET
    @Path(value="{id}/draft/workflow")
    @ResponseTypes(value={@ResponseType(status=200, value=WorkflowMappingBean.class), @ResponseType(status=200, value=List.class, genericTypes={WorkflowMappingBean.class})})
    public Response getDraftWorkflow(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName) {
        return this.withDraft(id, this.checkWorkflow(workflowName, true, new Function<RestWorkflowScheme, Response>(){

            public Response apply(RestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(workflowName == null ? input.asWorkflowBeans() : input.asWorkflowBean(workflowName));
            }
        }));
    }

    @DELETE
    @Path(value="{id}/workflow")
    public Response deleteWorkflowMapping(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName, final @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.checkWorkflow(workflowName, false, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.deleteWorkflow(workflowName, updateDraftIfNeeded);
            }
        })));
    }

    @DELETE
    @Path(value="{id}/draft/workflow")
    public Response deleteDraftWorkflowMapping(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName) {
        return this.withDraft(id, this.checkWorkflow(workflowName, false, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.deleteWorkflow(workflowName);
            }
        })));
    }

    @PUT
    @Path(value="{id}/workflow")
    @RequestType(value=WorkflowMappingBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response updateWorkflowMapping(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName, final WorkflowMappingBean updateBean) {
        return this.withScheme(id, this.checkWorkflow(workflowName, false, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                updateBean.setWorkflow(workflowName);
                return input.updateWorkflowMappings(updateBean);
            }
        })));
    }

    @PUT
    @Path(value="{id}/draft/workflow")
    @RequestType(value=WorkflowMappingBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response updateDraftWorkflowMapping(@PathParam(value="id") long id, final @QueryParam(value="workflowName") String workflowName, final WorkflowMappingBean updateBean) {
        return this.withDraft(id, this.checkWorkflow(workflowName, false, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                updateBean.setWorkflow(workflowName);
                return input.updateWorkflowMappings(updateBean);
            }
        })));
    }

    @GET
    @Path(value="{id}/issuetype/{issueType}")
    @ResponseType(value=IssueTypeMappingBean.class)
    public Response getIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.checkIssueType(issueType, this.draftMaybe(returnDraftIfExists, new Function<RestWorkflowScheme, Response>(){

            public Response apply(RestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asIssueTypeBean(issueType));
            }
        })));
    }

    @GET
    @Path(value="{id}/draft/issuetype/{issueType}")
    @ResponseType(value=IssueTypeMappingBean.class)
    public Response getDraftIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType) {
        return this.withDraft(id, this.checkIssueType(issueType, new Function<DraftRestWorkflowScheme, Response>(){

            public Response apply(DraftRestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asIssueTypeBean(issueType));
            }
        }));
    }

    @DELETE
    @Path(value="{id}/issuetype/{issueType}")
    public Response deleteIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType, final @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.checkIssueType(issueType, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.removeIssueType(issueType, updateDraftIfNeeded);
            }
        })));
    }

    @DELETE
    @Path(value="{id}/draft/issuetype/{issueType}")
    public Response deleteDraftIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType) {
        return this.withDraft(id, this.checkIssueType(issueType, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.removeIssueType(issueType);
            }
        })));
    }

    @PUT
    @Path(value="{id}/issuetype/{issueType}")
    @RequestType(value=IssueTypeMappingBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response setIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType, final IssueTypeMappingBean mappingBean) {
        return this.withScheme(id, this.checkIssueType(issueType, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                mappingBean.setIssueType(issueType);
                return input.updateIssueTypeMappings(mappingBean);
            }
        })));
    }

    @PUT
    @Path(value="{id}/draft/issuetype/{issueType}")
    @RequestType(value=IssueTypeMappingBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    public Response setDraftIssueType(@PathParam(value="id") long id, final @PathParam(value="issueType") String issueType, final IssueTypeMappingBean mappingBean) {
        return this.withDraft(id, this.checkIssueType(issueType, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                mappingBean.setIssueType(issueType);
                return input.updateIssueTypeMappings(mappingBean);
            }
        })));
    }

    @GET
    @ResponseType(value=DefaultBean.class)
    @Path(value="{id}/default")
    public Response getDefault(@PathParam(value="id") long id, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.draftMaybe(returnDraftIfExists, new Function<RestWorkflowScheme, Response>(){

            public Response apply(RestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asDefaultBean());
            }
        }));
    }

    @GET
    @ResponseType(value=DefaultBean.class)
    @Path(value="{id}/draft/default")
    public Response getDraftDefault(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)new Function<DraftRestWorkflowScheme, Response>(){

            public Response apply(DraftRestWorkflowScheme input) {
                return WorkflowSchemeResource.responseOk(input.asDefaultBean());
            }
        });
    }

    @DELETE
    @Path(value="{id}/default")
    public Response deleteDefault(@PathParam(value="id") long id, final @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.removeDefault(updateDraftIfNeeded);
            }
        }));
    }

    @DELETE
    @Path(value="{id}/draft/default")
    public Response deleteDraftDefault(@PathParam(value="id") long id) {
        return this.withDraft(id, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.removeDefault();
            }
        }));
    }

    @PUT
    @RequestType(value=DefaultBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    @Path(value="{id}/default")
    public Response updateDefault(@PathParam(value="id") long id, final DefaultBean bean) {
        return this.withScheme(id, this.buildResponse(new Function<AssignableRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(AssignableRestWorkflowScheme input) {
                return input.updateDefault(bean);
            }
        }));
    }

    @PUT
    @RequestType(value=DefaultBean.class)
    @ResponseType(value=WorkflowSchemeBean.class)
    @Path(value="{id}/draft/default")
    public Response updateDraftDefault(@PathParam(value="id") long id, final DefaultBean bean) {
        return this.withDraft(id, this.buildResponse(new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.updateDefault(bean);
            }
        }));
    }

    private static Response response(ServiceOutcome<?> outcome) {
        if (outcome.isValid()) {
            if (outcome.getReturnedValue() == null) {
                return WorkflowSchemeResource.responseNoContent();
            }
            return WorkflowSchemeResource.responseOk(outcome.getReturnedValue());
        }
        return WorkflowSchemeResource.responseError(outcome);
    }

    private static Response responseNoContent() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private static Response responseOk(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    private static Response responseCreated(WorkflowSchemeBean entity) {
        return Response.created((URI)entity.getSelf()).entity((Object)entity).cacheControl(CacheControl.never()).build();
    }

    private static Response responseError(ServiceOutcome<?> outcome) {
        com.atlassian.jira.util.ErrorCollection errorCollection = outcome.getErrorCollection();
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        if (reason == null) {
            reason = ErrorCollection.Reason.SERVER_ERROR;
        }
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private Response responseError(Response.Status reason, String key, Object ... args) {
        String msg = this.authenticationContext.getI18nHelper().getText(key, (Object)args);
        return Response.status((Response.Status)reason).entity((Object)ErrorCollection.of(msg)).cacheControl(CacheControl.never()).build();
    }

    private Response withScheme(long id, Function<? super AssignableRestWorkflowScheme, Response> function) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        return (Response)function.apply(outcome.getReturnedValue());
    }

    private Response withDraft(long parentId, Function<? super DraftRestWorkflowScheme, Response> function) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(parentId);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        ServiceOutcome<DraftRestWorkflowScheme> draftOutcome = ((AssignableRestWorkflowScheme)outcome.getReturnedValue()).getDraftScheme();
        if (!draftOutcome.isValid()) {
            return WorkflowSchemeResource.responseError(draftOutcome);
        }
        return (Response)function.apply(draftOutcome.getReturnedValue());
    }

    private <I> Function<I, Response> checkIssueType(final String issueType, final Function<I, Response> function) {
        return new Function<I, Response>(){

            public Response apply(@Nullable I input) {
                if (issueType == null || WorkflowSchemeResource.this.issueTypeManager.getIssueType(issueType) == null) {
                    return WorkflowSchemeResource.this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.issuetype.does.not.exist", new Object[]{issueType});
                }
                return (Response)function.apply(input);
            }
        };
    }

    private <I> Function<I, Response> checkWorkflow(final String workflow, final boolean allowNull, final Function<I, Response> function) {
        return new Function<I, Response>(){

            public Response apply(@Nullable I input) {
                if (workflow == null) {
                    if (!allowNull) {
                        return WorkflowSchemeResource.this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.workflow.not.passed", new Object[]{workflow});
                    }
                } else if (WorkflowSchemeResource.this.workflowManager.getWorkflow(workflow) == null) {
                    return WorkflowSchemeResource.this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.workflow.does.not.exist", new Object[]{workflow});
                }
                return (Response)function.apply(input);
            }
        };
    }

    private <I> Function<I, Response> buildResponse(final Function<I, ServiceOutcome<? extends RestWorkflowScheme>> function) {
        return new Function<I, Response>(){

            public Response apply(@Nullable I input) {
                ServiceOutcome outcome = (ServiceOutcome)function.apply(input);
                if (outcome.isValid()) {
                    return WorkflowSchemeResource.responseOk(((RestWorkflowScheme)outcome.getReturnedValue()).asBean());
                }
                return WorkflowSchemeResource.responseError(outcome);
            }
        };
    }

    private Function<AssignableRestWorkflowScheme, Response> draftMaybe(final boolean draft, final Function<RestWorkflowScheme, Response> function) {
        return new Function<AssignableRestWorkflowScheme, Response>(){

            public Response apply(AssignableRestWorkflowScheme input) {
                if (draft) {
                    return (Response)function.apply((Object)input.getDraftMaybe());
                }
                return (Response)function.apply((Object)input);
            }
        };
    }
}

