/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBeanFactory;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

abstract class RestWorkflowScheme {
    final WorkflowSchemeBeanFactory beanFactory;

    protected RestWorkflowScheme(WorkflowSchemeBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    static Map<String, String> getWorkflowMap(WorkflowScheme currentScheme, WorkflowSchemeBean bean) {
        HashMap mappings = bean.getIssueTypeMappings() != null ? Maps.newHashMap(bean.getIssueTypeMappings()) : (currentScheme != null ? Maps.newHashMap((Map)currentScheme.getMappings()) : Maps.newHashMap());
        if (bean.isDefaultSet()) {
            if (bean.getDefaultWorkflow() != null) {
                mappings.put(null, bean.getDefaultWorkflow());
            } else {
                mappings.remove(null);
            }
        } else if (currentScheme != null && currentScheme.getConfiguredDefaultWorkflow() != null) {
            mappings.put(null, currentScheme.getConfiguredDefaultWorkflow());
        }
        return mappings;
    }

    void mergeWorkflowMappings(WorkflowScheme.Builder<?> builder, WorkflowMappingBean bean) {
        if (bean.getIssueTypes() != null) {
            HashSet removeIssueTypes = Sets.newHashSet();
            for (Map.Entry entry : builder.getMappings().entrySet()) {
                String workflowName;
                String issueType = (String)entry.getKey();
                if (issueType == null || !(workflowName = (String)entry.getValue()).equals(bean.getWorkflow())) continue;
                removeIssueTypes.add(issueType);
            }
            for (String types : bean.getIssueTypes()) {
                builder.setMapping(types, bean.getWorkflow());
                removeIssueTypes.remove(types);
            }
            for (String type : removeIssueTypes) {
                builder.removeMapping(type);
            }
        }
        if (bean.isDefaultMapping() != null) {
            if (bean.isDefaultMapping().booleanValue()) {
                builder.setDefaultWorkflow(bean.getWorkflow());
            } else if (bean.getWorkflow().equals(builder.getDefaultWorkflow())) {
                builder.removeDefault();
            }
        }
    }

    void mergeIssueTypeMapping(WorkflowScheme.Builder<?> builder, IssueTypeMappingBean bean) {
        if (bean.isWorkflowSet()) {
            if (bean.getWorkflow() != null) {
                builder.setMapping(bean.getIssueType(), bean.getWorkflow());
            } else {
                builder.removeMapping(bean.getIssueType());
            }
        }
    }

    static void setDefaultMapping(WorkflowScheme.Builder<?> builder, DefaultBean bean) {
        if (bean.isWorkflowSet()) {
            if (bean.getWorkflow() == null) {
                builder.removeDefault();
            } else {
                builder.setDefaultWorkflow(bean.getWorkflow());
            }
        }
    }

    static boolean asBoolean(Boolean bool) {
        return bool != null && bool != false;
    }

    WorkflowMappingBean asWorkflowBean(String workflow) {
        return WorkflowSchemeBeanFactory.asMappingBean(this.getScheme(), workflow);
    }

    IssueTypeMappingBean asIssueTypeBean(String issueType) {
        return WorkflowSchemeBeanFactory.asIssueTypeBean(this.getScheme(), issueType);
    }

    Iterable<WorkflowMappingBean> asWorkflowBeans() {
        return WorkflowSchemeBeanFactory.asMappingBeans(this.getScheme()).values();
    }

    DefaultBean asDefaultBean() {
        return WorkflowSchemeBeanFactory.asDefaultBean(this.getScheme());
    }

    abstract WorkflowScheme getScheme();

    abstract WorkflowSchemeBean asBean();

    abstract ServiceOutcome<Void> delete();

    abstract ServiceOutcome<? extends RestWorkflowScheme> update(WorkflowSchemeBean var1);
}

