/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.auditing;

import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ChangedValueBean {
    private String fieldName;
    private String changedFrom;
    private String changedTo;

    public ChangedValueBean() {
    }

    public ChangedValueBean(ChangedValue changedValue) {
        this.fieldName = changedValue.getName();
        this.changedFrom = changedValue.getFrom();
        this.changedTo = changedValue.getTo();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getChangedFrom() {
        return this.changedFrom;
    }

    public String getChangedTo() {
        return this.changedTo;
    }

    public ChangedValue toChangedValue() {
        Assertions.notBlank((String)"fieldName", (String)this.fieldName);
        return new ChangedValue(){

            @Nonnull
            public String getName() {
                return ChangedValueBean.this.fieldName;
            }

            @Nullable
            public String getFrom() {
                return ChangedValueBean.this.changedFrom;
            }

            @Nullable
            public String getTo() {
                return ChangedValueBean.this.changedTo;
            }
        };
    }

    public static Function<ChangedValueBean, ChangedValue> mapToChangedValue() {
        return new Function<ChangedValueBean, ChangedValue>(){

            public ChangedValue apply(@Nullable ChangedValueBean input) {
                return input != null ? input.toChangedValue() : null;
            }
        };
    }
}

