/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.applicationrole;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationRoleBeanConverter
implements Function<ApplicationRole, ApplicationRoleBean> {
    private final ApplicationRoleManager roleManager;
    private final ApplicationManager appManager;
    private final Supplier<Application> platform = new Supplier<Application>(){

        @Override
        public Application get() {
            return ApplicationRoleBeanConverter.this.appManager.getPlatform();
        }
    };

    @Autowired
    public ApplicationRoleBeanConverter(@ComponentImport ApplicationRoleManager roleManager, @ComponentImport ApplicationManager appManager) {
        this.roleManager = roleManager;
        this.appManager = appManager;
    }

    public ApplicationRoleBean roleBean(ApplicationRole role) {
        ApplicationKey key = role.getKey();
        int userCount = this.roleManager.getUserCount(key);
        Application application = (Application)this.appManager.getApplication(key).getOrElse(this.platform);
        String userCountDescription = application.getUserCountDescription(Option.some((Object)userCount));
        int remainingSeats = this.roleManager.getRemainingSeats(key);
        return new ApplicationRoleBean(key.value(), role.getName(), ApplicationRoleBeanConverter.toNames(role.getGroups()), ApplicationRoleBeanConverter.toNames(role.getDefaultGroups()), role.isSelectedByDefault(), role.isDefined(), role.getNumberOfSeats(), remainingSeats, userCount, userCountDescription, remainingSeats == -1, role.isPlatform());
    }

    public ApplicationRoleBean shortBean(ApplicationRole role) {
        return new ApplicationRoleBean(role.getKey().value(), role.getName(), null, null, null);
    }

    public Function<ApplicationRole, ApplicationRoleBean> toShortBean() {
        return new Function<ApplicationRole, ApplicationRoleBean>(){

            public ApplicationRoleBean apply(ApplicationRole input) {
                return ApplicationRoleBeanConverter.this.shortBean(input);
            }
        };
    }

    private static Set<String> toNames(Iterable<Group> groups) {
        HashSet names = Sets.newHashSet();
        for (Group group : groups) {
            names.add(group.getName());
        }
        return Collections.unmodifiableSet(names);
    }

    public ApplicationRoleBean apply(ApplicationRole input) {
        return this.roleBean(input);
    }
}

