/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.rest.v2.admin.ConfigurationBean;
import com.atlassian.jira.rest.v2.admin.TimeTrackingConfigurationBean;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationBeanFactory {
    private final VoteService voteService;
    private final WatcherService watcherService;
    private final ApplicationProperties applicationProperties;
    private final SubTaskManager subTaskManager;
    private final AttachmentManager attachmentManager;
    private final IssueLinkManager issueLinkManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;

    @Autowired
    public ConfigurationBeanFactory(VoteService voteService, WatcherService watcherService, ApplicationProperties applicationProperties, SubTaskManager subTaskManager, AttachmentManager attachmentManager, IssueLinkManager issueLinkManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        this.voteService = voteService;
        this.watcherService = watcherService;
        this.applicationProperties = applicationProperties;
        this.subTaskManager = subTaskManager;
        this.attachmentManager = attachmentManager;
        this.issueLinkManager = issueLinkManager;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
    }

    public ConfigurationBean createConfigurationBean() {
        boolean timeTrackingEnabled = this.timeTrackingConfiguration.enabled();
        if (timeTrackingEnabled) {
            return this.createConfigurationBean(true, (Option<TimeTrackingConfigurationBean>)Option.some((Object)this.createTimeTrackingConfiguration()));
        }
        return this.createConfigurationBean(false, (Option<TimeTrackingConfigurationBean>)Option.none(TimeTrackingConfigurationBean.class));
    }

    private ConfigurationBean createConfigurationBean(boolean timeTrackingEnabled, Option<TimeTrackingConfigurationBean> timeTrackingConfigurationBean) {
        return ConfigurationBean.builer().votingEnabled(this.voteService.isVotingEnabled()).watchingEnabled(this.watcherService.isWatchingEnabled()).unassignedIssuesAllowed(this.applicationProperties.getOption("jira.option.allowunassigned")).subTasksEnabled(this.subTaskManager.isSubTasksEnabled()).attachmentsEnabled(this.attachmentManager.attachmentsEnabled()).issueLinkingEnabled(this.issueLinkManager.isLinkingEnabled()).timeTrackingEnabled(timeTrackingEnabled).timeTrackingConfiguration((TimeTrackingConfigurationBean)timeTrackingConfigurationBean.getOrNull()).build();
    }

    private TimeTrackingConfigurationBean createTimeTrackingConfiguration() {
        double hoursPerDay = this.timeTrackingConfiguration.getHoursPerDay().doubleValue();
        double daysPerWeek = this.timeTrackingConfiguration.getDaysPerWeek().doubleValue();
        TimeTrackingConfiguration.TimeFormat timeFormat = this.timeTrackingConfiguration.getTimeFormat();
        TimeTrackingConfigurationBean.TimeTrackingUnit timeTrackingUnit = this.getTimeTrackingUnit();
        return new TimeTrackingConfigurationBean(hoursPerDay, daysPerWeek, timeFormat, timeTrackingUnit);
    }

    private TimeTrackingConfigurationBean.TimeTrackingUnit getTimeTrackingUnit() {
        DateUtils.Duration unit = this.timeTrackingConfiguration.getDefaultUnit();
        switch (unit) {
            case HOUR: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.hour;
            }
            case DAY: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.day;
            }
            case WEEK: {
                return TimeTrackingConfigurationBean.TimeTrackingUnit.week;
            }
        }
        return TimeTrackingConfigurationBean.TimeTrackingUnit.minute;
    }
}

