/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.renderers;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="render")
@AnonymousAllowed
@Consumes(value={"application/json", "application/x-www-form-urlencoded"})
@Produces(value={"text/html"})
@CorsAllowed
public class RenderersResource {
    public static final String FLAG_CONTENT_RENDER_ANONYMOUS = "CONTENT_RENDER_ANONYMOUS";
    private static final String NBSP = "&nbsp;";
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final IssueFactory issueFactory;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private I18nHelper.BeanFactory i18nFactory;

    public RenderersResource(RendererManager rendererManager, IssueManager issueManager, ProjectManager projectManager, IssueFactory issueFactory, ConstantsManager constantsManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, FeatureManager featureManager, IssueSecuritySchemeManager issueSecuritySchemeManager, I18nHelper.BeanFactory i18nHelperBeanFactory) {
        this.rendererManager = rendererManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.issueFactory = issueFactory;
        this.constantsManager = constantsManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.i18nFactory = i18nHelperBeanFactory;
    }

    @POST
    public Response getRenderedContent(ContentToRender contentToRender) {
        String content = this.getPreviewHtml(contentToRender);
        if (content != null) {
            return Response.ok((Object)content).cacheControl(CacheControl.NO_CACHE).build();
        }
        I18nHelper i18n = this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).entity((Object)String.format("<h1>%s</h1><p><span class=\"error\">%s</span></p>", i18n.getText("rest.error.issue.render.resource.not.permitted"), i18n.getText("rest.error.issue.render.resource.not.permitted.hint"))).build();
    }

    public String getPreviewHtml(ContentToRender content) {
        String key = content.issueKey;
        String type = content.issueType;
        String projectId = content.projectId;
        if (!StringUtils.isEmpty((CharSequence)key)) {
            if (this.userHasAccessToIssue(content)) {
                MutableIssue issue = this.issueManager.getIssueObject(key);
                return this.doGetPreviewHtml(content, issue.getIssueRenderContext());
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)projectId) || StringUtils.isEmpty((CharSequence)type)) {
                return this.doGetPreviewHtml(content, new IssueRenderContext(null));
            }
            if (this.userHasAccessToProject(content)) {
                return this.doGetPreviewHtml(content, this.generateRenderContext(projectId, type));
            }
        }
        return null;
    }

    private boolean userHasAccessToProject(ContentToRender contentToRender) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        Project project = this.projectManager.getProjectObjByKey(contentToRender.projectId);
        return project != null && (this.featureManager.getDarkFeatures().isFeatureEnabled(FLAG_CONTENT_RENDER_ANONYMOUS) || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, loggedInUser, true));
    }

    private boolean userHasAccessToIssue(ContentToRender contentToRender) {
        MutableIssue issue;
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            issue = this.issueManager.getIssueObject(contentToRender.issueKey);
        }
        catch (DataAccessException e) {
            issue = null;
        }
        return issue != null && (this.featureManager.getDarkFeatures().isFeatureEnabled(FLAG_CONTENT_RENDER_ANONYMOUS) || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, loggedInUser) && this.issueSecuritySchemeManager.hasSecurityLevelAccess((Issue)issue, loggedInUser));
    }

    private IssueRenderContext generateRenderContext(String projectId, String issueType) {
        Project projectObj;
        try {
            projectObj = this.projectManager.getProjectObj(Long.valueOf(projectId));
            if (projectObj == null) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(projectObj);
        if (this.constantsManager.getIssueTypeObject(issueType) != null) {
            issue.setIssueTypeId(issueType);
        }
        IssueRenderContext renderContext = new IssueRenderContext((Issue)issue);
        renderContext.addParam((Object)"jira.issue", (Object)issue);
        return renderContext;
    }

    private String doGetPreviewHtml(ContentToRender contentToRender, IssueRenderContext renderContext) {
        String result;
        if (contentToRender.forWysiwyg) {
            renderContext.addParam((Object)"atlassian-renderer-for-wysiwyg", (Object)Boolean.TRUE);
            renderContext.addParam((Object)"atlassian-renderer-form-token", (Object)contentToRender.formToken);
        }
        return StringUtils.isBlank((CharSequence)(result = this.rendererManager.getRenderedContent(contentToRender.rendererType, contentToRender.unrenderedMarkup, renderContext))) ? NBSP : result;
    }

    @XmlRootElement
    public static class ContentToRender {
        @XmlElement
        private String rendererType;
        @XmlElement
        private String unrenderedMarkup;
        @XmlElement
        private String issueKey;
        @XmlElement
        private String projectId;
        @XmlElement
        private String issueType;
        @XmlElement
        private boolean forWysiwyg;
        @XmlElement
        private String formToken;

        public ContentToRender() {
        }

        public ContentToRender(String rendererType, String unrenderedMarkup, String issueKey, String projectId, String issueType, boolean forWysiwyg, String formToken) {
            this.rendererType = rendererType;
            this.unrenderedMarkup = unrenderedMarkup;
            this.issueKey = issueKey;
            this.projectId = projectId;
            this.issueType = issueType;
            this.forWysiwyg = forWysiwyg;
            this.formToken = formToken;
        }
    }
}

