/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.labels;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="labels")
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class IssueLabelsResource {
    private static final Logger log = LoggerFactory.getLogger(IssueLabelsResource.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LabelService labelService;
    private final I18nHelper i18nHelper;
    private final ApplicationProperties applicationProperties;
    private static final int DEFAULT_MAX_SUGGESTIONS = 20;
    private final XsrfInvocationChecker xsrfChecker;

    public IssueLabelsResource(JiraAuthenticationContext jiraAuthenticationContext, LabelService labelService, I18nHelper i18nHelper, ApplicationProperties applicationProperties, XsrfInvocationChecker xsrfChecker) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.labelService = labelService;
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.xsrfChecker = xsrfChecker;
    }

    private Response createInvalidIssueResponse(Long issueId) {
        return Response.ok().entity((Object)ErrorCollection.Builder.newBuilder().addErrorMessage(this.i18nHelper.getText("label.service.error.issue.doesnt.exist", (Object)issueId)).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="{issueId}")
    public Response getLabels(@PathParam(value="issueId") Long issueId, @QueryParam(value="customFieldId") Long customFieldId) {
        if (issueId == null) {
            return this.createInvalidIssueResponse(issueId);
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        LabelService.LabelsResult result = customFieldId == null ? this.labelService.getLabels(user, issueId) : this.labelService.getLabels(user, issueId, customFieldId);
        return IssueLabelsResource.createGetLabelsResponse(result);
    }

    @GET
    @Path(value="suggest")
    public Response getSuggestions(@QueryParam(value="customFieldId") Long customFieldId, @QueryParam(value="query") String token) {
        return this.getSuggestionsHelper(null, customFieldId, token);
    }

    @GET
    @Path(value="{issueId}/suggest")
    public Response getSuggestions(@PathParam(value="issueId") Long issueId, @QueryParam(value="customFieldId") Long customFieldId, @QueryParam(value="query") String token) {
        if (issueId == null) {
            return this.createInvalidIssueResponse(issueId);
        }
        return this.getSuggestionsHelper(issueId, customFieldId, token);
    }

    private Response getSuggestionsHelper(Long issueId, Long customFieldId, String token) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        LabelService.LabelSuggestionResult suggestionResult = customFieldId == null ? this.labelService.getSuggestedLabels(user, issueId, token) : this.labelService.getSuggestedLabels(user, issueId, customFieldId, token);
        if (suggestionResult.isValid()) {
            Set suggestions = suggestionResult.getSuggestions();
            return this.createGetSuggestionsResponse(token, suggestions, this.addHighlights(suggestions, token));
        }
        return IssueLabelsResource.createErrorResponse((ServiceResultImpl)suggestionResult);
    }

    private Set<String> addHighlights(Set<String> suggestions, String token) {
        LinkedHashSet<String> highlightedSuggestions = new LinkedHashSet<String>(suggestions.size());
        for (String suggestion : suggestions) {
            String matched = "<b>" + TextUtils.htmlEncode((String)suggestion.substring(0, token.length())) + "</b>" + TextUtils.htmlEncode((String)suggestion.substring(token.length()));
            highlightedSuggestions.add(matched);
        }
        return highlightedSuggestions;
    }

    private Response createGetSuggestionsResponse(String input, Set<String> suggestions, Set<String> highlightedSuggestions) {
        long limit = this.getSuggestionLimit();
        int count = 0;
        SuggestionListStruct result = new SuggestionListStruct(StringUtils.trim((String)input));
        if (suggestions.size() != highlightedSuggestions.size()) {
            log.warn("Somehow we have different lengths for the highlighted suggestions.");
        }
        Iterator<String> suggestionIterator = suggestions.iterator();
        Iterator<String> highlightedIterator = highlightedSuggestions.iterator();
        while (suggestionIterator.hasNext() && highlightedIterator.hasNext()) {
            String suggestion = suggestionIterator.next();
            String highlighted = highlightedIterator.next();
            result.addSuggestion(suggestion, highlighted);
            if ((long)(++count) < limit) continue;
            break;
        }
        return Response.ok((Object)result).cacheControl(CacheControl.NO_CACHE).build();
    }

    private long getSuggestionLimit() {
        String labelString = this.applicationProperties.getDefaultString("jira.ajax.autocomplete.labelsuggestion.limit");
        long limit = 20L;
        if (StringUtils.isNumeric((CharSequence)labelString) && (limit = Long.parseLong(labelString)) == 0L) {
            limit = Long.MAX_VALUE;
        }
        return limit;
    }

    @POST
    @Path(value="{issueId}")
    public Response setLabels(@PathParam(value="issueId") Long issueId, @QueryParam(value="customFieldId") Long customFieldId, @FormParam(value="labels") String concatenatedLabels) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        if (issueId == null) {
            return this.createInvalidIssueResponse(issueId);
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        Set<String> labels = IssueLabelsResource.splitLabels(concatenatedLabels);
        LabelService.SetLabelValidationResult validationResult = customFieldId == null ? this.labelService.validateSetLabels(user, issueId, labels) : this.labelService.validateSetLabels(user, issueId, customFieldId, labels);
        if (validationResult.isValid()) {
            return IssueLabelsResource.createGetLabelsResponse(this.labelService.setLabels(user, validationResult, false, true));
        }
        return IssueLabelsResource.createErrorResponse((ServiceResultImpl)validationResult);
    }

    public static Set<String> splitLabels(String concatenatedLabels) {
        if (concatenatedLabels == null || StringUtils.isBlank((CharSequence)concatenatedLabels)) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(concatenatedLabels.split("\\s")));
    }

    private static Response createGetLabelsResponse(LabelService.LabelsResult result) {
        if (result.isValid()) {
            LabelListStruct labels = new LabelListStruct();
            for (Label label : result.getLabels()) {
                labels.addLabel(label);
            }
            return Response.ok((Object)labels).cacheControl(CacheControl.NO_CACHE).build();
        }
        return IssueLabelsResource.createErrorResponse((ServiceResultImpl)result);
    }

    private static Response createErrorResponse(ServiceResultImpl result) {
        return Response.ok().entity((Object)ErrorCollection.Builder.newBuilder().addErrorCollection(result.getErrorCollection()).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class SuggestionStruct {
        @XmlElement
        private String label;
        @XmlElement
        private String html;

        public SuggestionStruct() {
        }

        public SuggestionStruct(String label, String highLightedLabel) {
            this.label = label;
            this.html = highLightedLabel;
        }

        public String label() {
            return this.label;
        }

        public String html() {
            return this.html;
        }
    }

    @XmlRootElement
    public static class SuggestionListStruct {
        @XmlElement
        private String token;
        @XmlElement
        private Set<SuggestionStruct> suggestions = new LinkedHashSet<SuggestionStruct>();

        public SuggestionListStruct() {
        }

        public SuggestionListStruct(String token) {
            this.token = token;
        }

        public SuggestionListStruct addSuggestion(String label, String highlightedLabel) {
            this.suggestions.add(new SuggestionStruct(label, highlightedLabel));
            return this;
        }

        public Set<SuggestionStruct> suggestions() {
            return new LinkedHashSet<SuggestionStruct>(this.suggestions);
        }
    }

    @XmlRootElement
    public static class LabelStruct {
        @XmlElement
        private Long id;
        @XmlElement
        private String label;

        public LabelStruct() {
        }

        public LabelStruct(Long id, String label) {
            this.id = id;
            this.label = label;
        }
    }

    @XmlRootElement
    public static class LabelListStruct {
        @XmlElement
        private Set<LabelStruct> labels = new LinkedHashSet<LabelStruct>();

        public LabelListStruct addLabel(Label label) {
            this.labels.add(new LabelStruct(label.getId(), label.getLabel()));
            return this;
        }
    }
}

