/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util.serializers;

import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.util.I18nHelper;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.PerRequestTypeInjectableProvider;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;

@Provider
public class DateTimeInjector
extends PerRequestTypeInjectableProvider<QueryParam, DateTime> {
    private final I18nHelper i18nHelper;

    @Inject
    public DateTimeInjector(I18nHelper i18n) {
        super(DateTime.class);
        this.i18nHelper = i18n;
    }

    public Injectable<DateTime> getInjectable(ComponentContext cc, final QueryParam a) {
        return new AbstractHttpContextInjectable<DateTime>(){

            public DateTime getValue(HttpContext ctx) {
                List values = (List)ctx.getRequest().getQueryParameters().get((Object)a.value());
                if (values == null || values.isEmpty()) {
                    return null;
                }
                if (values.size() > 1) {
                    String badDateParameterMessage = DateTimeInjector.this.i18nHelper.getText("BAD_DATE", a.value());
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)badDateParameterMessage).build());
                }
                try {
                    DateTime paramDate = Dates.fromISODateTimeString((String)((String)values.get(0)));
                    return paramDate;
                }
                catch (IllegalArgumentException exc) {
                    String badDateMessage = DateTimeInjector.this.i18nHelper.getText("BAD_DATE", (String)values.get(0));
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)badDateMessage).build());
                }
            }
        };
    }
}

