/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.config.Configuration;

public class AttachmentHelper {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final XsrfInvocationChecker xsrfChecker;
    private final JiraAuthenticationContext authenticationContext;

    public AttachmentHelper(XsrfInvocationChecker xsrfChecker, JiraAuthenticationContext jiraAuthenticationContext) {
        this.xsrfChecker = xsrfChecker;
        this.authenticationContext = jiraAuthenticationContext;
    }

    public ValidationResult validate(HttpServletRequest request, String filename, @Nullable Long size) {
        ServletInputStream inputStream;
        Long largestAttachmentSize;
        long actualFileSize;
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(request);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return new ValidationResult(ValidationError.XSRF_TOKEN_INVALID, this.getText("xsrf.error.title", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)filename)) {
            return new ValidationResult(ValidationError.FILENAME_BLANK, null);
        }
        if (size == null || size < 0L) {
            actualFileSize = request.getContentLength();
            if (actualFileSize < 0L) {
                return new ValidationResult(ValidationError.ATTACHMENT_IO_SIZE, this.getText("attachfile.error.io.size", filename));
            }
        } else {
            actualFileSize = size;
        }
        if (actualFileSize > (largestAttachmentSize = new Long(this.getMaxAttachmentSize()))) {
            return new ValidationResult(ValidationError.ATTACHMENT_TO_LARGE, this.getText("avatarpicker.upload.size.toobig", filename, FileSize.format((Long)largestAttachmentSize)));
        }
        try {
            inputStream = request.getInputStream();
        }
        catch (IOException e) {
            return new ValidationResult(ValidationError.ATTACHMENT_IO_UNKNOWN, this.getText("attachfile.error.io.error", filename));
        }
        String contentType = (String)StringUtils.defaultIfBlank((CharSequence)request.getContentType(), (CharSequence)DEFAULT_CONTENT_TYPE);
        return new ValidationResult((InputStream)inputStream, actualFileSize, contentType);
    }

    String getMaxAttachmentSize() {
        return Configuration.getString((String)"webwork.multipart.maxSize");
    }

    private String getText(String text, Object ... args) {
        return this.authenticationContext.getI18nHelper().getText(text, (Object)args);
    }

    public static class ValidationResult {
        private final long size;
        private final InputStream inputStream;
        private final String contentType;
        private final ValidationError errorType;
        private final String errorMessage;

        public ValidationResult(InputStream inputStream, long size, String contentType) {
            this.inputStream = inputStream;
            this.size = size;
            this.contentType = contentType;
            this.errorType = null;
            this.errorMessage = null;
        }

        public ValidationResult(ValidationError errorType, String errorMessage) {
            this.inputStream = null;
            this.size = -1L;
            this.contentType = null;
            this.errorType = errorType;
            this.errorMessage = errorMessage;
        }

        public long getSize() {
            return this.size;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getContentType() {
            return this.contentType;
        }

        public ValidationError getErrorType() {
            return this.errorType;
        }

        public boolean isValid() {
            return this.errorType == null;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("size", this.size).add("contentType", (Object)this.contentType).add("errorType", (Object)this.errorType).add("errorMessage", (Object)this.errorMessage).toString();
        }
    }

    public static enum ValidationError {
        ATTACHMENT_TO_LARGE,
        ATTACHMENT_IO_SIZE,
        ATTACHMENT_IO_UNKNOWN,
        FILENAME_BLANK,
        XSRF_TOKEN_INVALID;

    }
}

