/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.serializer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.json.JacksonJsonProviderFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueSerializer
extends JsonSerializer<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValueSerializer.class);
    private static final JacksonJsonProvider jacksonJsonProvider = new JacksonJsonProviderFactory().create((Iterable)Lists.newArrayList((Object[])new DefaultValueModule[]{new DefaultValueModule()}));

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try {
            String json = jacksonJsonProvider.locateMapper(value.getClass(), MediaType.APPLICATION_JSON_TYPE).writeValueAsString(value);
            if (StringUtils.isNotBlank((CharSequence)json)) {
                jgen.writeRaw(":" + json);
            } else {
                jgen.writeNull();
            }
        }
        catch (Exception e) {
            LOG.error("Cannot serialize value: " + value, (Throwable)e);
            jgen.writeNull();
        }
    }

    private static class DefaultValueModule
    extends SimpleModule {
        private Optional<JiraBaseUrls> jiraBaseUrls = Optional.empty();

        public DefaultValueModule() {
            super("Default value ", new Version(1, 0, 0, null));
            this.addSerializers();
        }

        private void addSerializers() {
            this.addSerializer(ApplicationUser.class, (JsonSerializer)new JsonSerializer<ApplicationUser>(){

                public void serialize(ApplicationUser value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (this.getJiraBaseUrls().isPresent()) {
                        jgen.writeObject((Object)new UserBeanBuilder((JiraBaseUrls)jiraBaseUrls.get()).user(value).buildShort());
                    }
                }
            });
            this.addSerializer(Priority.class, (JsonSerializer)new JsonSerializer<Priority>(){

                public void serialize(Priority value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (this.getJiraBaseUrls().isPresent()) {
                        jgen.writeObject((Object)PriorityJsonBean.shortBean((Priority)value, (JiraBaseUrls)((JiraBaseUrls)this.getJiraBaseUrls().get())));
                    }
                }
            });
            this.addSerializer(Label.class, (JsonSerializer)new JsonSerializer<Label>(){

                public void serialize(Label value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (StringUtils.isNotBlank((CharSequence)value.getLabel())) {
                        jgen.writeString(value.getLabel());
                    }
                }
            });
            this.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

                public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeString(Dates.asTimeString((Date)value));
                }
            });
            this.addSerializer(Timestamp.class, (JsonSerializer)new JsonSerializer<Timestamp>(){

                public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeString(Dates.asTimeString((Timestamp)value));
                }
            });
        }

        private Optional<JiraBaseUrls> getJiraBaseUrls() {
            if (!this.jiraBaseUrls.isPresent()) {
                this.jiraBaseUrls = ComponentAccessor.getComponentSafely(JiraBaseUrls.class);
            }
            return this.jiraBaseUrls;
        }
    }
}

