/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.WarningCollection;
import com.atlassian.jira.rest.internal.v2.user.AffectedEntityBean;
import com.atlassian.jira.rest.internal.v2.user.ResultWithErrorsAndWarningsBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class UserAnonymizationValidationBean
extends ResultWithErrorsAndWarningsBean {
    public static final UserAnonymizationValidationBean DOC_EXAMPLE = new UserAnonymizationValidationBean("JIRAUSER10100", "fred", "Fred Flinston", "fred@example.com", Collections.emptyMap(), Collections.emptyMap(), (Map<AffectedEntityType, List<AffectedEntityBean>>)ImmutableMap.of((Object)AffectedEntityType.ANONYMIZE, (Object)ImmutableList.of((Object)AffectedEntityBean.DOC_EXAMPLE)));
    public static final UserAnonymizationValidationBean ERROR_DOC_EXAMPLE = new UserAnonymizationValidationBean("JIRAUSER10100", (Map<String, ErrorCollection>)ImmutableMap.of((Object)"GENERAL", (Object)ErrorCollection.of("An error coming from general validation, e.g. permission validation or a user trying to anonymize themselves"), (Object)AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE.toString(), (Object)ErrorCollection.of("Error coming from a particular operation step")), (Map<String, WarningCollection>)ImmutableMap.of((Object)"com.atlassian.jira.example:plugin-module", (Object)WarningCollection.of("Some warning message", "Another warning message"), (Object)"com.atlassian.jira.example2:different-plugin-module", (Object)WarningCollection.of("An oopsie! Something went wrong!")), Collections.emptyMap());
    @XmlElement
    private String userKey;
    @XmlElement
    private String userName;
    @XmlElement
    private String displayName;
    @XmlElement
    private String email;
    @XmlElement
    private boolean success;
    @XmlElement
    private Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities;

    private UserAnonymizationValidationBean() {
    }

    private UserAnonymizationValidationBean(@Nonnull String userKey, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, WarningCollection> warnings, @Nonnull Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities) {
        this(userKey, null, null, null, errors, warnings, affectedEntities);
    }

    private UserAnonymizationValidationBean(@Nonnull String userKey, @Nullable String userName, @Nullable String displayName, @Nullable String email, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, WarningCollection> warnings, @Nonnull Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities) {
        super(errors, warnings);
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.displayName = displayName;
        this.email = email;
        this.affectedEntities = Objects.requireNonNull(affectedEntities);
        this.success = errors.isEmpty();
    }

    public static UserAnonymizationValidationBean from(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull I18nHelper i18n) {
        Optional<ApplicationUser> userOptional = UserAnonymizationValidationBean.getUser(validationResult);
        String userKey = validationResult.getRequest().getUserKey();
        Map<String, ErrorCollection> errors = UserAnonymizationValidationBean.buildErrors(validationResult);
        Map<String, WarningCollection> warnings = UserAnonymizationValidationBean.buildWarnings(validationResult);
        Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities = UserAnonymizationValidationBean.buildAffectedEntities(validationResult, i18n);
        if (!userOptional.isPresent()) {
            return new UserAnonymizationValidationBean(userKey, errors, warnings, affectedEntities);
        }
        ApplicationUser user = userOptional.get();
        return new UserAnonymizationValidationBean(userKey, user.getName(), user.getDisplayName(), user.getEmailAddress(), errors, warnings, affectedEntities);
    }

    @Nonnull
    private static Map<String, ErrorCollection> buildErrors(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        Map<String, ErrorCollection> errors = UserAnonymizationValidationBean.getErrorsFromOperationReport(validationResult.getAffectedEntitiesReport());
        Map<String, ErrorCollection> operationValidationErrors = UserAnonymizationValidationBean.getErrorsFromOperationReport(validationResult.getOperationValidation());
        operationValidationErrors.forEach((k, v) -> errors.merge((String)k, (ErrorCollection)v, ErrorCollection::addErrorCollection));
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            errors.put("GENERAL", ErrorCollection.of(validationResult.getErrorCollection()));
        }
        return errors;
    }

    @Nonnull
    private static Map<String, WarningCollection> buildWarnings(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        Map<String, WarningCollection> warnings = UserAnonymizationValidationBean.getWarningsFromOperationReport(validationResult.getAffectedEntitiesReport());
        Map<String, WarningCollection> operationValidationWarnings = UserAnonymizationValidationBean.getWarningsFromOperationReport(validationResult.getOperationValidation());
        operationValidationWarnings.forEach((k, v) -> warnings.merge((String)k, (WarningCollection)v, WarningCollection::addWarningCollection));
        if (validationResult.getWarningCollection().hasAnyWarnings()) {
            warnings.put("GENERAL", WarningCollection.of(validationResult.getWarningCollection()));
        }
        return warnings;
    }

    @Nonnull
    private static Map<AffectedEntityType, List<AffectedEntityBean>> buildAffectedEntities(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull I18nHelper i18n) {
        return validationResult.getAffectedEntitiesReport().getReports().stream().flatMap(report -> ((Collection)report.getResult().get()).stream()).map(affectedEntity -> AffectedEntityBean.from(affectedEntity, i18n)).collect(Collectors.groupingBy(AffectedEntityBean::getType));
    }

    @Nonnull
    private static Optional<ApplicationUser> getUser(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        return processData != null ? Optional.ofNullable(processData.getUser()) : Optional.empty();
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nonnull
    public Map<AffectedEntityType, List<AffectedEntityBean>> getAffectedEntities() {
        return this.affectedEntities;
    }
}

