/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.internal.v2.user.UserAnonymizationProgressBean;
import com.atlassian.jira.rest.internal.v2.user.UserAnonymizationRequestBean;
import com.atlassian.jira.rest.internal.v2.user.UserAnonymizationValidationBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AnonymizationResult;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.AnonymizeUserTaskContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rest.annotation.RequestType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="user/anonymization")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserAnonymizationResource {
    private static final Logger log = Logger.getLogger(UserAnonymizationResource.class);
    private final AnonymizeUserService anonymizeUserService;
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserManager userManager;
    private final TaskManager taskManager;
    private final I18nHelper i18n;

    UserAnonymizationResource(@ComponentImport AnonymizeUserService anonymizeUserService, JiraAuthenticationContext authenticationContext, GlobalPermissionManager globalPermissionManager, JiraBaseUrls jiraBaseUrls, UserManager userManager, TaskManager taskManager, I18nHelper i18n) {
        this.anonymizeUserService = anonymizeUserService;
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userManager = userManager;
        this.taskManager = taskManager;
        this.i18n = i18n;
    }

    @GET
    public Response validateUserAnonymization(@QueryParam(value="userKey") String userKey) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.forbidden"))).build();
        }
        if (StringUtils.isBlank((CharSequence)userKey)) {
            return this.missingParameterResponse("userKey");
        }
        AnonymizeUserService.AnonymizeValidationResult validationResult = this.anonymizeUserService.preValidateAnonymize(AnonymizeUserService.AnonymizeUserRequest.builder().targetUser(userKey).executor(this.authenticationContext.getLoggedInUser()).build());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)UserAnonymizationValidationBean.from(validationResult, this.i18n)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequestType(value=UserAnonymizationRequestBean.class)
    public Response scheduleUserAnonymization(UserAnonymizationRequestBean userAnonymizationRequestBean) throws URISyntaxException {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.forbidden"))).build();
        }
        if (StringUtils.isBlank((CharSequence)userAnonymizationRequestBean.userKey)) {
            return this.missingParameterResponse("userKey");
        }
        AnonymizeUserTaskContext anonymizeUserTaskContext = this.createTaskContextFromRequest(userAnonymizationRequestBean);
        if (this.taskManager.hasLiveTaskWithContext((TaskContext)anonymizeUserTaskContext)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.already.running"))).build();
        }
        String taskName = this.i18n.getText("rest.user.anonymize.task");
        TaskDescriptor task = this.taskManager.submitTask((Callable)new AnonymizeUserCommand(userAnonymizationRequestBean), taskName, (TaskContext)anonymizeUserTaskContext);
        return Response.status((Response.Status)Response.Status.ACCEPTED).location(new URI(this.jiraBaseUrls.baseUrl() + task.getProgressURL())).entity((Object)UserAnonymizationProgressBean.fromTaskDescriptor((TaskDescriptor<AnonymizationResult>)task)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="progress")
    @RequestType(value=UserAnonymizationRequestBean.class)
    public Response getProgress(@QueryParam(value="taskId") long taskId) throws URISyntaxException {
        Optional<TaskDescriptor<?>> task;
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.progress.forbidden"))).build();
        }
        Optional<TaskDescriptor<?>> optional = task = taskId > 0L ? this.getTaskById(taskId) : this.getLastTask();
        if (!task.isPresent()) {
            return this.taskNotFoundResponse();
        }
        return this.taskProgressResponse(task.get());
    }

    @Nonnull
    private AnonymizeUserTaskContext createTaskContextFromRequest(@Nonnull UserAnonymizationRequestBean requestBean) {
        ApplicationUser user = this.userManager.getUserByKey(requestBean.userKey);
        if (user != null) {
            return new AnonymizeUserTaskContext(user.getKey(), user.getName(), user.getDisplayName());
        }
        return new AnonymizeUserTaskContext(requestBean.userKey);
    }

    @Nonnull
    private Optional<TaskDescriptor<?>> getTaskById(long taskId) {
        TaskDescriptor task = this.taskManager.getTask(Long.valueOf(taskId));
        if (task != null && task.getTaskContext() instanceof AnonymizeUserTaskContext) {
            return Optional.of(task);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<TaskDescriptor<?>> getLastTask() {
        Collection anonymizationTasks = this.taskManager.findTasks(descriptor -> descriptor.getTaskContext() instanceof AnonymizeUserTaskContext);
        return anonymizationTasks.stream().max(Comparator.comparing(TaskDescriptor::getTaskId));
    }

    @Nonnull
    private Response missingParameterResponse(@Nonnull String fieldName) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.missing.parameter", fieldName))).build();
    }

    @Nonnull
    private Response taskProgressResponse(@Nonnull TaskDescriptor<?> task) throws URISyntaxException {
        try {
            TaskDescriptor<?> anonymizationResultTaskDescriptor = task;
            return Response.status((Response.Status)Response.Status.OK).location(new URI(this.jiraBaseUrls.baseUrl() + task.getProgressURL())).entity((Object)UserAnonymizationProgressBean.fromTaskDescriptor(anonymizationResultTaskDescriptor)).cacheControl(CacheControl.never()).build();
        }
        catch (ClassCastException e) {
            return this.taskNotFoundResponse();
        }
    }

    @Nonnull
    private Response taskNotFoundResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.progress.no.task.found"))).build();
    }

    private class AnonymizeUserCommand
    implements Callable<AnonymizationResult>,
    ProvidesTaskProgress {
        private static final String ANONYMIZATION_PERCENTAGE = "rest.user.anonymize.percent.complete";
        private static final String ANONYMIZATION_CURRENT_TASK = "rest.user.anonymize.current.task";
        private final UserAnonymizationRequestBean requestBean;
        private volatile TaskProgressSink taskProgressSink;

        private AnonymizeUserCommand(UserAnonymizationRequestBean requestBean) {
            this.requestBean = requestBean;
        }

        @Override
        public AnonymizationResult call() throws Exception {
            AnonymizeUserService.AnonymizeValidationResult validationResult = UserAnonymizationResource.this.anonymizeUserService.validateAnonymize(AnonymizeUserService.AnonymizeUserRequest.builder().targetUser(this.requestBean.userKey).newOwnerKey(this.requestBean.newOwnerKey).rerunPluginPoints(this.requestBean.rerunPluginPoints).oldUserKey(this.requestBean.oldUserKey).oldUserName(this.requestBean.oldUserName).executor(UserAnonymizationResource.this.authenticationContext.getLoggedInUser()).build());
            if (!validationResult.isValid()) {
                log.info((Object)String.format("User anonymization of user with key '%s' rejected due to a failed validation", this.requestBean.userKey));
                return AnonymizationResult.from((AnonymizeUserService.AnonymizeValidationResult)validationResult);
            }
            int stepsCount = UserAnonymizationResource.this.anonymizeUserService.getStepCount(validationResult);
            return AnonymizationResult.from((AnonymizeUserService.AnonymizePerformResult)UserAnonymizationResource.this.anonymizeUserService.perform(validationResult, this.createContext(stepsCount)));
        }

        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }

        private Context createContext(int stepsCount) {
            if (this.taskProgressSink == null) {
                log.warn((Object)"User anonymization is being started without the ability to report progress of sub-tasks.");
                return Contexts.nullContext();
            }
            return Contexts.builder().progress(this.taskProgressSink, UserAnonymizationResource.this.i18n, ANONYMIZATION_PERCENTAGE, ANONYMIZATION_CURRENT_TASK).sized((Sized)new FixedSized(stepsCount)).build();
        }
    }
}

