/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.WarningCollection;
import com.atlassian.jira.rest.bind.DateTimeAdapter;
import com.atlassian.jira.rest.internal.v2.user.ResultWithErrorsAndWarningsBean;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.user.anonymize.AnonymizationResult;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.AnonymizeUserTaskContext;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class UserAnonymizationProgressBean
extends ResultWithErrorsAndWarningsBean {
    public static final UserAnonymizationProgressBean DOC_EXAMPLE = new UserAnonymizationProgressBean("fred#2", "fred", "Fred Senior", "/rest/internal/2/user/anonymization/progress?taskId=10001", 100L, "Name of a handler", new Date(), new Date(), new Date(), true, Collections.emptyMap(), Collections.emptyMap());
    public static final UserAnonymizationProgressBean ERROR_DOC_EXAMPLE = new UserAnonymizationProgressBean("fred#2", "fred", "Fred Senior", "/rest/internal/2/user/anonymization/progress?taskId=10002", 100L, "Name of a handler", new Date(), new Date(), new Date(), false, (Map<String, ErrorCollection>)ImmutableMap.of((Object)"GENERAL", (Object)ErrorCollection.of("An error coming from general validation, e.g. permission validation or a user trying to anonymize themselves"), (Object)AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE.toString(), (Object)ErrorCollection.of("Error coming from a particular operation step")), (Map<String, WarningCollection>)ImmutableMap.of((Object)"com.atlassian.jira.example:plugin-module", (Object)WarningCollection.of("Some warning message", "Another warning message"), (Object)"com.atlassian.jira.example2:different-plugin-module", (Object)WarningCollection.of("An oopsie! Something went wrong!")));
    @XmlElement
    private String userKey;
    @XmlElement
    private String userName;
    @XmlElement
    private String fullName;
    @XmlElement
    private String progressUrl;
    @XmlElement
    private long currentProgress;
    @XmlElement
    private String currentSubTask;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date submittedTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date startTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date finishTime;
    @XmlElement
    private boolean success;

    private UserAnonymizationProgressBean() {
    }

    private UserAnonymizationProgressBean(@Nonnull String userKey, @Nullable String userName, @Nullable String fullName, @Nonnull String progressUrl, long currentProgress, @Nullable String currentSubTask, @Nonnull Date submittedTime, @Nullable Date startTime, @Nullable Date finishTime, boolean success, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, WarningCollection> warnings) {
        super(errors, warnings);
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.fullName = fullName;
        this.progressUrl = Objects.requireNonNull(progressUrl);
        this.currentProgress = currentProgress;
        this.currentSubTask = currentSubTask;
        this.submittedTime = Objects.requireNonNull(submittedTime);
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.success = success;
    }

    public static UserAnonymizationProgressBean fromTaskDescriptor(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        AnonymizeUserTaskContext taskContext = (AnonymizeUserTaskContext)task.getTaskContext();
        TaskProgressEvent lastProgressEvent = task.getTaskProgressIndicator().getLastProgressEvent();
        long progress = lastProgressEvent != null ? lastProgressEvent.getTaskProgress() : 0L;
        String currentSubTask = lastProgressEvent != null ? lastProgressEvent.getCurrentSubTask() : null;
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrors(task);
        Map<String, WarningCollection> warnings = UserAnonymizationProgressBean.getWarnings(task);
        boolean success = task.isFinished() && errors.isEmpty();
        return new UserAnonymizationProgressBean(taskContext.getUserKey(), taskContext.getUserName(), taskContext.getFullName(), task.getProgressURL(), task.getFinishedTimestamp() != null ? 100L : progress, currentSubTask, task.getSubmittedTimestamp(), task.getStartedTimestamp(), task.getFinishedTimestamp(), success, errors, warnings);
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Nonnull
    public String getProgressUrl() {
        return this.progressUrl;
    }

    @Nonnull
    public Long getCurrentProgress() {
        return this.currentProgress;
    }

    @Nullable
    public String getCurrentSubTask() {
        return this.currentSubTask;
    }

    @Nonnull
    public Date getSubmittedTime() {
        return this.submittedTime;
    }

    @Nullable
    public Date getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Date getFinishTime() {
        return this.finishTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nonnull
    private static Map<String, ErrorCollection> getErrors(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptyMap();
        }
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrorsFromOperationReport(((AnonymizationResult)task.getResult()).getOperationsReport());
        if (((AnonymizationResult)task.getResult()).getValidationErrors().hasAnyErrors()) {
            errors.put("GENERAL", ErrorCollection.of(((AnonymizationResult)task.getResult()).getValidationErrors()));
        }
        return errors;
    }

    @Nonnull
    private static Map<String, WarningCollection> getWarnings(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptyMap();
        }
        return UserAnonymizationProgressBean.getWarningsFromOperationReport(((AnonymizationResult)task.getResult()).getOperationsReport());
    }
}

