/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityLink;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.util.I18nHelper;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class AffectedEntityBean
implements Serializable {
    public static final AffectedEntityBean DOC_EXAMPLE = new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", 1L, "User Profile", "/jira/secure/ViewProfile.jspa?name=fred");
    private AffectedEntityType type;
    @XmlElement
    private String description;
    @XmlElement
    private Long numberOfOccurrences;
    @XmlElement
    private String uriDisplayName;
    @XmlElement
    private String uri;

    private AffectedEntityBean() {
    }

    @VisibleForTesting
    public AffectedEntityBean(String description, Long numberOfOccurrences) {
        this(description, numberOfOccurrences, null, null);
    }

    @VisibleForTesting
    public AffectedEntityBean(String description, Long numberOfOccurrences, String uriDisplayName, String uri) {
        this(null, description, numberOfOccurrences, uriDisplayName, uri);
    }

    AffectedEntityBean(AffectedEntityType type, String description, Long numberOfOccurrences) {
        this(type, description, numberOfOccurrences, null, null);
    }

    AffectedEntityBean(AffectedEntityType type, String description, Long numberOfOccurrences, String uriDisplayName, String uri) {
        this.type = type;
        this.description = description;
        this.numberOfOccurrences = numberOfOccurrences;
        this.uriDisplayName = uriDisplayName;
        this.uri = uri;
    }

    @Nonnull
    public static AffectedEntityBean from(@Nonnull AffectedEntity affectedEntity, @Nonnull I18nHelper i18n) {
        Long occurences = affectedEntity.getNumberOfOccurrences().orElse(null);
        if (affectedEntity.getLink().isPresent()) {
            AffectedEntityLink link = (AffectedEntityLink)affectedEntity.getLink().get();
            return new AffectedEntityBean(affectedEntity.getType(), i18n.getText(affectedEntity.getDescriptionKey()), occurences, i18n.getText(link.getDisplayNameKey()), link.getUri().toString());
        }
        return new AffectedEntityBean(affectedEntity.getType(), i18n.getText(affectedEntity.getDescriptionKey()), occurences);
    }

    public AffectedEntityType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public String getUriDisplayName() {
        return this.uriDisplayName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedEntityBean that = (AffectedEntityBean)o;
        return this.type == that.type && Objects.equals(this.description, that.description) && Objects.equals(this.numberOfOccurrences, that.numberOfOccurrences) && Objects.equals(this.uriDisplayName, that.uriDisplayName) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.description, this.numberOfOccurrences, this.uriDisplayName, this.uri);
    }

    public String toString() {
        return "AffectedEntityBean{type=" + this.type + ", description='" + this.description + '\'' + ", numberOfOccurrences=" + this.numberOfOccurrences + ", uriDisplayName='" + this.uriDisplayName + '\'' + ", uri='" + this.uri + '\'' + '}';
    }
}

