/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.clusterlock;

import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.jira.rest.Dates;
import java.util.Date;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
class ClusterLockStatusBean {
    private static final double MILLIS_TO_SECONDS = 0.001;
    @JsonSerialize
    private final String lockName;
    @JsonSerialize
    private final String lockedByNode;
    @JsonSerialize
    private final String updateTime;
    @JsonSerialize
    private final String holdingLockSec;

    ClusterLockStatusBean(@Nonnull ClusterLockStatus clusterLockStatus) {
        this.lockName = clusterLockStatus.getLockName();
        this.lockedByNode = clusterLockStatus.getLockedByNode();
        this.updateTime = this.epochToIso8601(clusterLockStatus.getUpdateTime());
        this.holdingLockSec = this.secondsSince(clusterLockStatus.getUpdateTime());
    }

    private String epochToIso8601(long millis) {
        return Dates.asTimeString((Date)new Date(millis));
    }

    private String secondsSince(long millisEpoch) {
        return String.format("%.4f", (double)(System.currentTimeMillis() - millisEpoch) * 0.001);
    }
}

