/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.admin.applicationrole;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.admin.GroupLabelBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.admin.group.GroupLabelsService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@Path(value="applicationrole")
public class ApplicationRoleResource {
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupLabelsService groupLabelsService;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper i18nHelper;

    public ApplicationRoleResource(ApplicationRoleManager applicationRoleManager, GroupLabelsService groupLabelsService, GlobalPermissionManager permissionManager, JiraAuthenticationContext authenticationContext, I18nHelper i18nHelper) {
        this.applicationRoleManager = applicationRoleManager;
        this.groupLabelsService = groupLabelsService;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.i18nHelper = i18nHelper;
    }

    @Path(value="groups")
    @GET
    public Response getGroups() {
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(new String[0])).build();
        }
        ImmutableSet groupBeans = (ImmutableSet)this.applicationRoleManager.getRoles().stream().map(ApplicationRole::getGroups).flatMap(Collection::stream).map(this::toGroupBean).collect(CollectorsUtil.toImmutableSet());
        return Response.ok((Object)groupBeans).cacheControl(CacheControl.never()).build();
    }

    private GroupBean toGroupBean(Group group) {
        List labels = this.groupLabelsService.getGroupLabels(group, Optional.empty());
        return new GroupBean(group.getName(), GroupLabelBean.toLabelsBeansList(labels));
    }

    @XmlRootElement(name="group")
    public static class GroupBean {
        @XmlElement
        private final String name;
        @XmlElement
        private final List<GroupLabelBean> labels;

        public GroupBean(String name, List<GroupLabelBean> labels) {
            this.name = name;
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupBean groupBean = (GroupBean)o;
            if (!this.labels.equals(groupBean.labels)) {
                return false;
            }
            return this.name.equals(groupBean.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.labels.hashCode();
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("labels", this.labels).toString();
        }
    }
}

