/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.exception;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionInterceptor
implements ResourceInterceptor {
    private final Logger log = LoggerFactory.getLogger(ExceptionInterceptor.class);
    private final I18nHelper i18n;

    public ExceptionInterceptor(I18nHelper i18n) {
        this.i18n = i18n;
    }

    public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        try {
            invocation.invoke();
        }
        catch (InvocationTargetException e) {
            Response response = this.createResponseFor(invocation, e.getCause());
            if (response.getStatus() >= 500) {
                this.log.error("Returning internal server error in response", (Throwable)e);
            }
            invocation.getHttpContext().getResponse().setResponse(response);
        }
    }

    Response createResponseFor(MethodInvocation invocation, Throwable cause) {
        MediaType mediaType = this.determineMediaTypeFor(invocation);
        this.log.debug("Setting response mediaType to: {}", (Object)mediaType);
        if (cause instanceof WebApplicationException) {
            WebApplicationException appException = (WebApplicationException)cause;
            return Response.fromResponse((Response)appException.getResponse()).type(mediaType).build();
        }
        ErrorCollection errors = ErrorCollection.of(this.i18n.getText("rest.error.internal"));
        return Response.serverError().entity((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private MediaType determineMediaTypeFor(MethodInvocation invocation) {
        for (MediaType accepted : invocation.getHttpContext().getRequest().getAcceptableMediaTypes()) {
            for (MediaType produces : invocation.getMethod().getSupportedOutputTypes()) {
                if (!accepted.isCompatible(produces)) continue;
                return produces;
            }
        }
        throw new IllegalStateException("Failed to negotiate correct media type for response");
    }
}

