/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.auth;

import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.bc.security.login.DeniedReason;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.auth.AuthParams;
import com.atlassian.jira.rest.auth.AuthSuccess;
import com.atlassian.jira.rest.auth.CurrentUser;
import com.atlassian.jira.rest.auth.LoginInfo;
import com.atlassian.jira.rest.auth.SessionInfo;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.filter.PasswordBasedLoginFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="session")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class Login {
    private final LoginService loginService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final I18nHelper i18n;

    public Login(LoginService loginService, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, I18nHelper i18n) {
        this.loginService = loginService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.i18n = i18n;
    }

    @GET
    @ResponseType(value=CurrentUser.class)
    public Response currentUser() throws URISyntaxException {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        String fullPath = baseUrl + "/rest/api/latest/user?username=" + JiraUrlCodec.encode((String)user.getName());
        URI selfUri = new URI(fullPath);
        CurrentUser currentUser = new CurrentUser().userName(user.getName()).self(selfUri).loginInfo(new LoginInfo(this.loginService.getLoginInfo(user.getName())));
        return Response.ok((Object)currentUser).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequestType(value=AuthParams.class)
    @ResponseType(value=AuthSuccess.class)
    public Response login(AuthParams credentials, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        String loginOutcome = new LoginResourceFilter(credentials.username, credentials.password).login(request, response);
        if ("success".equals(loginOutcome)) {
            SessionInfo sessionInfo = new SessionInfo("JSESSIONID", request.getSession().getId());
            LoginInfo loginInfo = new LoginInfo(this.loginService.getLoginInfo(credentials.username));
            AuthSuccess authSuccess = new AuthSuccess(sessionInfo, loginInfo);
            return Response.ok((Object)authSuccess).build();
        }
        LoginResult loginResult = (LoginResult)request.getAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult");
        if (loginResult != null && loginResult.getReason() == LoginReason.AUTHENTICATION_DENIED) {
            this.stampDeniedReasonsOnResponse(response, loginResult.getDeniedReasons());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.login.denied"))).build();
        }
        response.setHeader("WWW-Authenticate", "JIRA REST POST");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of(this.i18n.getText("rest.login.failed"))).build();
    }

    @DELETE
    public Response logout(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        if (this.jiraAuthenticationContext.getUser() == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        this.loginService.logout(request, response);
        ActionContextKit.resetContext();
        return Response.noContent().build();
    }

    protected void stampDeniedReasonsOnResponse(HttpServletResponse response, Set<DeniedReason> deniedReasons) {
        for (DeniedReason reason : deniedReasons) {
            response.setHeader("X-Authentication-Denied-Reason", reason.asString());
        }
    }

    private class LoginResourceFilter
    extends PasswordBasedLoginFilter {
        private final String username;
        private final String password;

        private LoginResourceFilter(String username, String password) {
            this.username = username;
            this.password = password;
        }

        protected PasswordBasedLoginFilter.UserPasswordPair extractUserPasswordPair(HttpServletRequest request) {
            return new PasswordBasedLoginFilter.UserPasswordPair(this.username, this.password, false);
        }

        protected SecurityConfig getSecurityConfig() {
            return SecurityConfigFactory.getInstance();
        }
    }
}

