/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user.anonymization;

import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.AffectedEntityBean;
import com.atlassian.jira.rest.v2.user.anonymization.ResultWithErrorsAndWarningsBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserAnonymizationValidationBean
extends ResultWithErrorsAndWarningsBean {
    @XmlAttribute(name="expand")
    private String expand;
    @JsonProperty
    @Schema(example="JIRAUSER10100")
    private String userKey;
    @JsonProperty
    @Schema(example="fred")
    private String userName;
    @JsonProperty
    @Schema(example="Fred Flinston")
    private String displayName;
    @JsonProperty
    @Schema(example="false")
    private boolean deleted;
    @JsonProperty
    @Schema(example="fred@example.com")
    private String email;
    @JsonProperty
    @Schema(example="true")
    private boolean success;
    @JsonProperty
    private Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities;
    @Expandable(value="affectedEntities")
    @XmlTransient
    private String affectedEntitiesExpandable = "";
    @JsonProperty
    @Schema(example="[\"USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS\",\"USER_DISABLE\",\"USER_KEY_CHANGE_PLUGIN_POINTS\",\"USER_KEY_CHANGE\",\"USER_NAME_CHANGE_PLUGIN_POINTS\",\"USER_NAME_CHANGE\",\"USER_EXTERNAL_ID_CHANGE\",\"USER_ANONYMIZE_PLUGIN_POINTS\"]")
    private Set<String> operations;
    @JsonProperty
    @Schema(example="true")
    private boolean businessLogicValidationFailed;

    private UserAnonymizationValidationBean() {
    }

    private UserAnonymizationValidationBean(@Nonnull String userKey, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, ErrorCollection> warnings, @Nullable Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities, @Nonnull Set<String> operations, boolean businessLogicValidationFailed) {
        this(userKey, null, null, null, false, errors, warnings, affectedEntities, operations, businessLogicValidationFailed);
    }

    private UserAnonymizationValidationBean(@Nonnull String userKey, @Nullable String userName, @Nullable String displayName, @Nullable String email, boolean deleted, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, ErrorCollection> warnings, @Nullable Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities, @Nonnull Set<String> operations, boolean businessLogicValidationFailed) {
        super(errors, warnings);
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.displayName = displayName;
        this.email = email;
        this.deleted = deleted;
        this.affectedEntities = affectedEntities;
        this.operations = Objects.requireNonNull(operations);
        this.businessLogicValidationFailed = businessLogicValidationFailed;
        this.success = errors.isEmpty();
    }

    public static UserAnonymizationValidationBean from(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull I18nHelper i18n) {
        Optional<ApplicationUser> userOptional = UserAnonymizationValidationBean.getUser(validationResult);
        String userKey = validationResult.getRequest().getUserKey();
        Map<String, ErrorCollection> errors = UserAnonymizationValidationBean.buildErrors(validationResult);
        Map<String, ErrorCollection> warnings = UserAnonymizationValidationBean.buildWarnings(validationResult);
        Map<AffectedEntityType, List<AffectedEntityBean>> affectedEntities = validationResult.getRequest().isGetAffectedEntities() ? UserAnonymizationValidationBean.buildAffectedEntities(validationResult, i18n) : null;
        boolean isBusinessLogicValidationFailed = !validationResult.getBusinessLogicValidationResult().isValid();
        Set<String> operations = UserAnonymizationValidationBean.getOperationsFromValidationResult(validationResult);
        if (!userOptional.isPresent()) {
            return new UserAnonymizationValidationBean(userKey, errors, warnings, affectedEntities, operations, isBusinessLogicValidationFailed);
        }
        ApplicationUser user = userOptional.get();
        boolean userDeleted = Optional.ofNullable(validationResult.getProcessData()).map(AnonymizeUserService.AnonymizeProcessData::isUserDeleted).orElse(false);
        return new UserAnonymizationValidationBean(userKey, user.getName(), user.getDisplayName(), user.getEmailAddress(), userDeleted, errors, warnings, affectedEntities, operations, isBusinessLogicValidationFailed);
    }

    @Nonnull
    private static Set<String> getOperationsFromValidationResult(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        return ((Collection)Optional.ofNullable(validationResult.getProcessData()).map(processData -> processData.getOperationsWeWouldLikeToPerform(false)).orElse(Collections.emptyList())).stream().map(Enum::toString).collect(Collectors.toSet());
    }

    @Nonnull
    private static Map<String, ErrorCollection> buildErrors(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        Map<String, ErrorCollection> errors = UserAnonymizationValidationBean.getErrorsFromOperationReport(validationResult.getAffectedEntitiesReport());
        Map<String, ErrorCollection> operationValidationErrors = UserAnonymizationValidationBean.getErrorsFromOperationReport(validationResult.getOperationValidation());
        operationValidationErrors.forEach((k, v) -> errors.merge((String)k, (ErrorCollection)v, ErrorCollection::addErrorCollection));
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            errors.put("GENERAL", ErrorCollection.of(validationResult.getErrorCollection()));
        }
        if (!validationResult.getBusinessLogicValidationResult().isValid()) {
            errors.putAll(UserAnonymizationValidationBean.buildBLLogicErrors(validationResult));
        }
        return errors;
    }

    @Nonnull
    private static Map<String, ErrorCollection> buildWarnings(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        Map<String, ErrorCollection> warnings = UserAnonymizationValidationBean.getWarningsFromOperationReport(validationResult.getAffectedEntitiesReport());
        Map<String, ErrorCollection> operationValidationWarnings = UserAnonymizationValidationBean.getWarningsFromOperationReport(validationResult.getOperationValidation());
        operationValidationWarnings.forEach((k, v) -> warnings.merge((String)k, (ErrorCollection)v, ErrorCollection::addErrorCollection));
        if (validationResult.hasWarnings()) {
            warnings.put("GENERAL", ErrorCollection.of(validationResult.getWarnings()));
        }
        return warnings;
    }

    @Nonnull
    private static Map<AffectedEntityType, List<AffectedEntityBean>> buildAffectedEntities(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull I18nHelper i18n) {
        return validationResult.getAffectedEntitiesReport().getReports().stream().map(report -> (Collection)report.getResult().get()).filter(Objects::nonNull).flatMap(Collection::stream).map(affectedEntity -> AffectedEntityBean.from(affectedEntity, i18n)).collect(Collectors.groupingBy(AffectedEntityBean::getType));
    }

    private static Map<String, ErrorCollection> buildBLLogicErrors(AnonymizeUserService.AnonymizeValidationResult validationResult) {
        return (Map)validationResult.getBusinessLogicValidationResult().getHandlerToErrorsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)entry.getValue())));
    }

    @Nonnull
    private static Optional<ApplicationUser> getUser(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        return processData != null ? Optional.ofNullable(processData.getUser()) : Optional.empty();
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public Map<AffectedEntityType, List<AffectedEntityBean>> getAffectedEntities() {
        return this.affectedEntities;
    }

    @Nonnull
    public Set<String> getOperations() {
        return this.operations;
    }

    @Nullable
    public String getExpand() {
        return this.expand;
    }

    public boolean isBusinessLogicValidationFailed() {
        return this.businessLogicValidationFailed;
    }
}

