/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user.anonymization;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.ResultWithErrorsAndWarningsBean;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.user.anonymize.AnonymizationResult;
import com.atlassian.jira.user.anonymize.AnonymizeUserTaskContext;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@JsonIgnoreProperties(ignoreUnknown=true)
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class UserAnonymizationProgressBean
extends ResultWithErrorsAndWarningsBean {
    @JsonProperty
    @Schema(example="fred#2")
    private String userKey;
    @JsonProperty
    @Schema(example="fred")
    private String userName;
    @JsonProperty
    @Schema(example="Fred Senior")
    private String fullName;
    @JsonProperty
    @Schema(example="/rest/api/2/user/anonymization/progress?taskId=10001")
    private String progressUrl;
    @JsonProperty
    @Schema(example="100")
    private long currentProgress;
    @JsonProperty
    @Schema(example="Name of a handler")
    private String currentSubTask;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    @Schema(example="2020-01-01T12:00:00.000Z")
    private Date submittedTime;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    @Schema(example="2020-01-01T12:00:00.000Z")
    private Date startTime;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    @Schema(example="2020-01-01T12:00:00.000Z")
    private Date finishTime;
    @JsonProperty
    @Schema(example="[USER_NAME_CHANGE_PLUGIN_POINTS, USER_NAME_CHANGE, USER_KEY_CHANGE_PLUGIN_POINTS, USER_KEY_CHANGE, USER_ANONYMIZE_PLUGIN_POINTS, USER_DISABLE, USER_EXTERNAL_ID_CHANGE, USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS]")
    private Set<String> operations;
    @JsonProperty
    @Schema(example="COMPLETED")
    private AnonymizationStatus status;
    @JsonProperty
    @Schema(example="node1")
    private String executingNode;
    @JsonProperty
    @Schema(example="true")
    private boolean isRerun;

    private UserAnonymizationProgressBean() {
    }

    private UserAnonymizationProgressBean(String userKey, @Nullable String userName, @Nullable String fullName, String progressUrl, long currentProgress, @Nullable String currentSubTask, Date submittedTime, @Nullable Date startTime, @Nullable Date finishTime, @Nonnull AnonymizationStatus status, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, ErrorCollection> warnings, @Nonnull Set<String> operations, @Nonnull String executingNode, boolean isRerun) {
        super(errors, warnings);
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.fullName = fullName;
        this.progressUrl = Objects.requireNonNull(progressUrl);
        this.currentProgress = currentProgress;
        this.currentSubTask = currentSubTask;
        this.submittedTime = Objects.requireNonNull(submittedTime);
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.status = Objects.requireNonNull(status);
        this.operations = Objects.requireNonNull(operations);
        this.executingNode = Objects.requireNonNull(executingNode);
        this.isRerun = isRerun;
    }

    static UserAnonymizationProgressBean fromTaskDescriptor(TaskDescriptor<AnonymizationResult> task) {
        return UserAnonymizationProgressBean.fromTaskDescriptor(task, true);
    }

    static UserAnonymizationProgressBean fromTaskDescriptor(TaskDescriptor<AnonymizationResult> task, boolean isExecutingNodeAlive) {
        AnonymizeUserTaskContext taskContext = (AnonymizeUserTaskContext)task.getTaskContext();
        TaskProgressEvent lastProgressEvent = Optional.ofNullable(task.getTaskProgressIndicator()).map(TaskProgressIndicator::getLastProgressEvent).orElse(null);
        long progress = lastProgressEvent != null ? lastProgressEvent.getTaskProgress() : 0L;
        String currentSubTask = lastProgressEvent != null ? lastProgressEvent.getCurrentSubTask() : null;
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrors(task);
        Map<String, ErrorCollection> warnings = UserAnonymizationProgressBean.getWarnings(task);
        Set<String> operations = UserAnonymizationProgressBean.getOperations(task);
        AnonymizationStatus status = UserAnonymizationProgressBean.getAnonymizationStatus(task, isExecutingNodeAlive);
        String nodeId = task.getNodeId() != null ? task.getNodeId() : "";
        boolean isRerun = taskContext.isRerun();
        return new UserAnonymizationProgressBean(taskContext.getUserKey(), taskContext.getUserName(), taskContext.getFullName(), task.getProgressURL(), task.getFinishedTimestamp() != null ? 100L : progress, currentSubTask, task.getSubmittedTimestamp(), task.getStartedTimestamp(), task.getFinishedTimestamp(), status, errors, warnings, operations, nodeId, isRerun);
    }

    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    public String getProgressUrl() {
        return this.progressUrl;
    }

    public Long getCurrentProgress() {
        return this.currentProgress;
    }

    @Nullable
    public String getCurrentSubTask() {
        return this.currentSubTask;
    }

    public Date getSubmittedTime() {
        return this.submittedTime;
    }

    @Nullable
    public Date getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Date getFinishTime() {
        return this.finishTime;
    }

    public AnonymizationStatus getStatus() {
        return this.status;
    }

    public Set<String> getOperations() {
        return this.operations;
    }

    public String getExecutingNode() {
        return this.executingNode;
    }

    public boolean isRerun() {
        return this.isRerun;
    }

    @Nonnull
    private static Map<String, ErrorCollection> getErrors(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished() && !UserAnonymizationProgressBean.isBusinessLogicValidationFailed(task)) {
            return Collections.emptyMap();
        }
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrorsFromOperationReport(((AnonymizationResult)task.getResult()).getOperationsReport());
        for (Map.Entry entry : ((AnonymizationResult)task.getResult()).getValidationErrors().entrySet()) {
            errors.merge((String)entry.getKey(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)entry.getValue()), ErrorCollection::addErrorCollection);
        }
        return errors;
    }

    private static Map<String, ErrorCollection> getWarnings(TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptyMap();
        }
        AnonymizationResult result = (AnonymizationResult)task.getResult();
        Map validationWarnings = result.getValidationWarnings();
        Map<String, ErrorCollection> warningsFromValidation = UserAnonymizationProgressBean.convertErrorCollections(validationWarnings);
        Map<String, ErrorCollection> warningsFromOperationReport = UserAnonymizationProgressBean.getWarningsFromOperationReport(result.getOperationsReport());
        warningsFromValidation.putAll(warningsFromOperationReport);
        return warningsFromValidation;
    }

    private static Map<String, ErrorCollection> convertErrorCollections(Map<String, com.atlassian.jira.util.ErrorCollection> validationWarnings) {
        return validationWarnings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)entry.getValue())));
    }

    @Nonnull
    private static Set<String> getOperations(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptySet();
        }
        AnonymizationResult result = (AnonymizationResult)task.getResult();
        return result.getOperations().stream().map(Enum::toString).collect(Collectors.toSet());
    }

    private static AnonymizationStatus getAnonymizationStatus(TaskDescriptor<AnonymizationResult> task, boolean isExecutingNodeAlive) {
        if (UserAnonymizationProgressBean.isBusinessLogicValidationFailed(task)) {
            return AnonymizationStatus.VALIDATION_FAILED;
        }
        if (task.isFinished()) {
            return AnonymizationStatus.COMPLETED;
        }
        return isExecutingNodeAlive ? AnonymizationStatus.IN_PROGRESS : AnonymizationStatus.INTERRUPTED;
    }

    private static boolean isBusinessLogicValidationFailed(TaskDescriptor<AnonymizationResult> task) {
        if (task.getResult() == null) {
            return false;
        }
        return ((AnonymizationResult)task.getResult()).businessLogicValidationFailed();
    }

    public static enum AnonymizationStatus {
        COMPLETED,
        INTERRUPTED,
        IN_PROGRESS,
        VALIDATION_FAILED;

    }
}

